/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.preferences;

/**
 * Constant definitions for plug-in preferences
 */
public final class IssuePreferences {

    public static final String           P_ISSUES_ENABLED       = "issues.enabled";

    /**
     * Preference for the maximum amount of issues to write during a batch
     * validation operation. This is used to keep the amount of written issues
     * down to tolerable levels performance-wise.
     */
    public static final String           P_MAX_BATCH_ISSUES_TO_WRITE = "issues.batch.write.max";

    public static final boolean          DEFAULT_ISSUES_ENABLED = true;

    public static final int              DEFAULT_MAX_BATCH_ISSUES_TO_WRITE = 1000;

    public static final IssuePreferences DEFAULT                = new IssuePreferences(DEFAULT_ISSUES_ENABLED, DEFAULT_MAX_BATCH_ISSUES_TO_WRITE);

    public final boolean                 enabled;

    public final int                     maxBatchIssuesToWrite;

    public IssuePreferences(boolean enabled, int maxBatchIssuesToWrite) {
        this.enabled = enabled;
        this.maxBatchIssuesToWrite = maxBatchIssuesToWrite;
    }

}
