/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.request.Read;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;

public class AllModelIssues
extends BinaryRead<Resource, Boolean, Set<Resource>> {
    public AllModelIssues(Resource model) {
        super((Object)model, (Object)Boolean.FALSE);
    }

    public AllModelIssues(Resource model, boolean onlyUnresolved) {
        super((Object)model, (Object)onlyUnresolved);
    }

    public Set<Resource> perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        THashSet result = new THashSet();
        for (Resource issue : (Collection)graph.syncRequest((Read)new ObjectsWithType((Resource)this.parameter, L0.ConsistsOf, ISSUE.Issue))) {
            if (((Boolean)this.parameter2).booleanValue() && graph.hasStatement(issue, ISSUE.Resolved)) continue;
            result.add(issue);
        }
        Instances indexedIssues = (Instances)graph.getPossibleAdapter(ISSUE.Issue, Instances.class);
        if (indexedIssues != null) {
            result.addAll(indexedIssues.find(graph, (Resource)this.parameter));
        }
        return result;
    }
}

