/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.help.ui;

import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.help.HelpResources;
import org.simantics.help.ui.HelpFileEditor;
import org.simantics.help.ui.Messages;
import org.simantics.ui.workbench.ResourceEditorInput2;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.utils.ui.workbench.WorkbenchUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenHelpFileAdapter
extends AbstractResourceEditorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenHelpFileAdapter.class);

    public OpenHelpFileAdapter() {
        super(Messages.OpenHelpFileAdapter_HelpFileEditor);
    }

    protected String getEditorId() {
        return HelpFileEditor.getEditorId();
    }

    protected boolean canHandle(ReadGraph g, Resource input) throws DatabaseException {
        return g.isInstanceOf(input, HelpResources.getInstance((ReadGraph)g).HelpFile);
    }

    protected void openEditor(final Resource input) throws Exception {
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph g) throws DatabaseException {
                Variable variable = Variables.getVariable((ReadGraph)g, (Resource)input);
                final Resource model = (Resource)g.syncRequest((Read)new PossibleIndexRoot(input));
                final RVI rvi = variable.getPossibleRVI(g);
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String editorId = OpenHelpFileAdapter.this.getEditorId();
                            WorkbenchUtils.openEditor((String)editorId, (IEditorInput)new ResourceEditorInput2(editorId, input, model, rvi));
                        }
                        catch (PartInitException e) {
                            LOGGER.error("Failed to open an editor for help file.", (Throwable)e);
                        }
                    }
                });
            }
        });
    }
}

