/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphviz;

import java.util.ArrayList;
import org.simantics.graphviz.Graph;
import org.simantics.graphviz.Node;

public class Record {
    ArrayList<Object> fields = new ArrayList();
    boolean rotated = false;

    public void add(String label) {
        this.fields.add(new Field(label));
    }

    public void add(String id, String label) {
        this.fields.add(new IdentifiableField(id, label));
    }

    public void add(Record record) {
        this.fields.add(record);
    }

    public Node toNode(Graph g) {
        Node node = new Node(g);
        node.setShape("record");
        StringBuilder b = new StringBuilder();
        this.toString(b);
        node.setLabel(b.toString());
        return node;
    }

    private void toString(StringBuilder b) {
        if (this.rotated) {
            b.append('{');
        }
        int i = 0;
        while (i < this.fields.size()) {
            Object ff;
            Object f = this.fields.get(i);
            if (i > 0) {
                b.append('|');
            }
            if (f instanceof Field) {
                ff = (Field)f;
                b.append(((Field)ff).label);
            } else if (f instanceof IdentifiableField) {
                ff = (IdentifiableField)f;
                b.append('<');
                b.append(((IdentifiableField)ff).id);
                b.append('>');
                b.append(((IdentifiableField)ff).label);
            } else if (f instanceof Record) {
                ((Record)f).toString(b);
            }
            ++i;
        }
        if (this.rotated) {
            b.append('}');
        }
    }

    public void setRotated(boolean rotated) {
        this.rotated = rotated;
    }

    static class Field {
        String label;

        public Field(String label) {
            this.label = label;
        }
    }

    static class IdentifiableField {
        String id;
        String label;

        public IdentifiableField(String id, String label) {
            this.id = id;
            this.label = label;
        }
    }
}

