/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graphviz.internal.xdot;

import java.awt.Font;
import java.awt.Graphics2D;

public class SetFont implements DrawCommand {

	Font font;
	
	public SetFont(double points, String fontName) {
		font = Font.decode(fontName);		
		if(font != null)
			font = font.deriveFont((float)points);
		else
			font = Font.decode(Font.SANS_SERIF).deriveFont((float)points);
		//System.out.println(fontName + " " + font);
	}

	@Override
	public void draw(Graphics2D g) {
		g.setFont(font);		
	}

}
