/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graphviz;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 * 
 * @author Hannu Niemist
 */
public class Activator extends Plugin {

    // The plug-in ID
    public static final String PLUGIN_ID = "org.simantics.graphviz";

    // The shared instance
    private static Activator plugin;

    // private File stateDir;
    private Bundle bundle;
    private File DOT_EXE;

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.eclipse.core.runtime.Plugins#start(org.osgi.framework.BundleContext)
     */
    @Override
    public void start(BundleContext context) throws Exception {
        super.start(context);

        bundle = context.getBundle();
        URL url = FileLocator.toFileURL(bundle.getEntry("dot"));
        DOT_EXE = new File(url.getPath(), "dot.exe");

        plugin = this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.eclipse.core.runtime.Plugin#stop(org.osgi.framework.BundleContext)
     */
    @Override
    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    /**
     * Returns the shared instance
     * 
     * @return the shared instance
     */
    public static Activator getDefault() {
        return plugin;
    }

    public static File getDotExe() {
        Activator activator = getDefault();
        if(activator != null)
            return activator.DOT_EXE;
        else
            try {
                URL path = Activator.class.getResource(".");
                URL resource = new URL(path, "../../../../dot/dot.exe");
                return new File(URLDecoder.decode(resource.getPath(), "UTF-8"));
            } catch (IOException e) {
                e.printStackTrace();
                return null;
            }
    }

}
