/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graphviz;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

/**
 * Default implementation for IGraphPart.
 * 
 * @author Hannu Niemist
 */
public abstract class AbstractGraphPart extends AbstractAttributeContainer implements IGraphPart {

    IGraph parent;
    
    public AbstractGraphPart(IGraph parent) {
        this.parent = parent;
        parent.addPart(this);
    }

    @Override
    public IGraph getParent() {
        return parent;
    }
    
    @Override
    public String toString() {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        write(new PrintStream(ba));
        return ba.toString();
    }

}
