/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.graph.representation;

import java.util.TreeMap;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.serialization.Serializer;


/**
 * Transferable graph datatype. 
 * See <a href="https://www.simantics.org/wiki/index.php/Graph_exchange_format">specification</a>. 
 * @author Hannu Niemist�
 */
public class TransferableGraph2 extends TransferableGraph1 {
	
	public static Binding BINDING;
	public static Serializer SERIALIZER;

	public TransferableGraph2(int resourceCount, Identity[] identities,
			int[] statements, Value[] values, TreeMap<String, Variant> extensions) {
		super(resourceCount, identities, statements, values, extensions);	
	}

	public TransferableGraph2(int resourceCount, Identity[] identities,
			int[] statements, Value[] values) {
		super(resourceCount, identities, statements, values);	
	}	
	
	public static Binding getBinding() {
		return BINDING;
	}
	
	static {
		BINDING = Bindings.getBindingUnchecked( TransferableGraph2.class );
		SERIALIZER = TransferableGraph1Serializer.INSTANCE;
		Bindings.serializerRepository.put(BINDING, SERIALIZER);
	}
	
}
