package org.simantics.graph.query;

import org.simantics.databoard.util.URIStringUtils;


public class PathChild implements Path {
	public final String name;
	public final Path parent;
	
	public PathChild(String name, Path parent) {
		if(parent == null)
			System.out.println("ERR");
		this.name = name;
		this.parent = parent;
	}
	
	@Override
	public int hashCode() {
		return name.hashCode() + (parent == null ? 0 : 31 * parent.hashCode());
	}
	
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null || getClass() != obj.getClass())
			return false;
		PathChild other = (PathChild) obj;
		return name.equals(other.name) &&
			(parent == null ? other.parent == null : parent.equals(other.parent));		
	}
	
	@Override
	public String toString() {
		StringBuilder b = new StringBuilder();
		toString(b);
		return b.toString();
	}

	public void toString(StringBuilder b) {
		if(parent == null)
			b.append("http:/");
		else
			parent.toString(b);
		b.append("/");
		b.append(URIStringUtils.escape(name));
	}
	
	@Override
	public Path child(String childName) {
		return new PathChild(childName, this);
	}
}
