/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.svg;

import java.util.Locale;

//import org.apache.batik.bridge.BridgeContext;
//import org.apache.batik.bridge.GVTBuilder;
//import org.apache.batik.bridge.UserAgentAdapter;
//import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
//import org.apache.batik.dom.svg12.SVG12DOMImplementation;
//import org.apache.batik.dom.util.DOMUtilities;
//import org.apache.batik.gvt.GraphicsNode;
//import org.apache.batik.util.XMLResourceDescriptor;
//import org.w3c.dom.svg.SVGDocument;
//import org.w3c.dom.svg.SVGSVGElement;


/**
 * Utility methods for DOM and SVG document handling.
 * 
 * Currently disabled.
 * 
 * @author Tuukka Lehtonen
 */
final class SVGUtils {

    public static final Locale        formatLocale = Locale.US;

//    private static final NumberFormat nf           = NumberFormat.getNumberInstance(formatLocale);

    /**
     * Attempts to parse an SVG document form the specified input stream.
     * 
     * @param inp
     * @return
     * @throws IOException
     */
//    public static SVGDocument parseSVGStream(InputStream inp) throws IOException {
//        ClassLoader ldr = Thread.currentThread().getContextClassLoader();
//        Thread.currentThread().setContextClassLoader(SVGUtils.class.getClassLoader());
//        try {
//            String parser = XMLResourceDescriptor.getXMLParserClassName();
//            SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
//            SVGDocument doc = f.createSVGDocument(null, inp);
//            return doc;
//        } finally {
//            Thread.currentThread().setContextClassLoader(ldr);
//        }
//    }

    /**
     * Attempts to parse a String as svg/xml and return the resulting
     * SVGDocument.
     * 
     * @param svgData the svg/xml data
     * @return the resulting SVGDocument instance
     * @throws IOException when parsing as svg fails
     */
//    public static SVGDocument parseSVGString(String svgData) throws IOException {
//        ClassLoader ldr = Thread.currentThread().getContextClassLoader();
//        Thread.currentThread().setContextClassLoader(SVGUtils.class.getClassLoader());
//        try {
//            String parser = XMLResourceDescriptor.getXMLParserClassName();
//            SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
//            StringReader reader = new StringReader(svgData);
//            SVGDocument doc = f.createSVGDocument(null, reader);
//            return doc;
//        } finally {
//            Thread.currentThread().setContextClassLoader(ldr);
//        }
//    }
    
    /**
     * Attempts to parse a String as svg/xml and return the root SVGSVGElement
     * of the resulting SVGDocument.
     * 
     * @param svgData the svg/xml data
     * @return the resulting SVGDocument instance
     * @throws IOException when parsing as svg fails
     */
//    public static SVGSVGElement parseSVGStringToRoot(String svgData) throws IOException {
//        SVGDocument doc = parseSVGString(svgData);
//        return doc.getRootElement();
//    }
    
    /**
     * Transcodes an SVGDocument instance into String form.
     * 
     * @param doc the SVGDocument to transcode
     * @return the resulting string
     * @throws IOException if the document contains invalid data
     */
//    public static String svgToString(SVGDocument doc) throws IOException {
//        StringWriter writer = new StringWriter();
//        DOMUtilities.writeDocument(doc, writer);
//        writer.close();
//        return writer.toString();
//    }
    
    /**
     * Retrieves SVG document bounding box by constructing the corresponding GVT
     * tree and getting the bounding information from there.
     * 
     * <p>
     * This allows us to get the bounding box of the actual rendered output, not
     * just the bounding box of the primitives.
     * </p>
     * 
     * <p>
     * BEWARE: using the specified document with a JSVGCanvas after invoking
     * this method seems to break the functionality of the DOM/GVT binding in
     * the canvas. If you need to do that, 
     * 
     * @param doc
     * @param defaultValue the rectangle to return if the document has no
     *        bounding box
     * @return <code>null</code> if the document has no graphical elements,
     *         i.e. no real bounding box and the given defaultValue was
     *         <code>null</code>
     */
//    public static Rectangle2D getDocumentBoundingBox(SVGDocument doc, Rectangle2D defaultValue, boolean cloneDocument) {
//        if (cloneDocument)
//            doc = (SVGDocument) DOMUtilities.deepCloneDocument(doc, SVG12DOMImplementation.getDOMImplementation());
//
//        GVTBuilder builder = new GVTBuilder();
//        BridgeContext ctx = new BridgeContext(new UserAgentAdapter());
//        GraphicsNode gvtRoot = builder.build(ctx, doc);
//
//        Rectangle2D bounds = gvtRoot.getSensitiveBounds();
//        if (bounds == null)
//            return defaultValue;
//        
//        if (bounds.isEmpty())
//            return defaultValue;
//        
//        Rectangle2D bbox = new Rectangle2D.Float();
//        bbox.setFrame(bounds);
//        return bbox;
//    }

}
