/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.image.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Transparency;
import java.awt.geom.Rectangle2D;
import java.awt.image.VolatileImage;

import org.simantics.g2d.image.Image;

/**
 * Video-ram cache suitable for rasterized PaintableSymbols.
 * 
 * @see VRamImage
 * @author Toni Kalajainen
 */
public class VRamBufferedImage extends ImageProxy {

    Shape outline;
    final GraphicsConfiguration gc;
    VolatileImage image;
    int wid, hei;

    public VRamBufferedImage(Image original, GraphicsConfiguration gc) {
        super(original);
        assert(gc!=null);
        this.gc = gc;
        Rectangle2D bounds = original.getBounds();
        wid = (int) Math.ceil( bounds.getWidth() );
        hei = (int) Math.ceil( bounds.getHeight() );
    }

    synchronized VolatileImage restore()
    {
        if (image==null) {
            image = gc.createCompatibleVolatileImage(
                    wid, hei,
                    Transparency.TRANSLUCENT);
        }
        int validateResult = image.validate(gc);
        if (validateResult == VolatileImage.IMAGE_INCOMPATIBLE)
            return null;

        if (validateResult == VolatileImage.IMAGE_OK)
            return image;

        if (validateResult == VolatileImage.IMAGE_RESTORED /*raster.contentsLost()*/) {
            Rectangle2D bounds = source.getBounds();
            outline = source.getOutline();
            Graphics2D target = image.createGraphics();
            target.setBackground(new Color(255,255,255,0));
            target.clearRect(0, 0, image.getWidth(), image.getHeight());
            target.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            target.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            target.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            target.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            target.translate(-bounds.getMinX(), -bounds.getMinY());
            source.init(null);//new GraphicsContextImpl(new Rectangle2D.Double(0,0, image.getWidth(), image.getHeight()), null) );
            target.dispose();
            return image;
        }
        return null;
    }

    @Override
    public int hashCode() {
        return gc.hashCode() ^source.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof VRamBufferedImage)) return false;
        VRamBufferedImage o = (VRamBufferedImage) obj;
        return o.gc == gc && o.source.equals(source);
    }

    public Image getSource() {
        return source;
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return gc;
    }

}
