/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl.proxy;

import java.awt.Color;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.TextColor;

/**
 * @author Toni Kalajainen
 */
public class ProxyTextColor implements TextColor {

    private static final long serialVersionUID = 8773434910416626939L;

    TextColor orig;
    IProxyProvider provider;

    public ProxyTextColor(IProxyProvider provider, TextColor orig) {
        this.provider = provider;
        this.orig = orig;
    }

    @Override
    public Color getTextColor(IElement e) {
        return orig.getTextColor(provider.provide(e));
    }

    @Override
    public void setTextColor(IElement e, Color c) {
        orig.setTextColor(provider.provide(e), c);
    }

}
