/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl.proxy;

import java.awt.geom.Point2D;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Rotate;

/**
 * @author Toni Kalajainen
 */
public class ProxyRotate implements Rotate {

    private static final long serialVersionUID = -664455055939615831L;

    Rotate orig;
    IProxyProvider provider;

    public ProxyRotate(IProxyProvider provider, Rotate orig) {
        this.provider = provider;
        this.orig = orig;
    }


    @Override
    public double getAngle(IElement e) {
        return orig.getAngle(provider.provide(e));
    }

    @Override
    public void rotate(IElement e, double theta, Point2D origo) {
        orig.rotate(provider.provide(e), theta, origo);
    }

}
