/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import java.awt.geom.Rectangle2D;
import java.util.Collection;

import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.LifeCycle;
import org.simantics.g2d.element.handler.Resize;
import org.simantics.g2d.element.handler.Validator;

/**
 * This handler is used by elements whose internal size can be modified
 * (eg. free graphics). 
 * 
 * @author Toni Kalajainen
 */
public class Resizeable implements Resize, LifeCycle, Validator {

    private static final long serialVersionUID = -2892730866940581731L;
    public final static Resizeable UNCONSTRICTED = new Resizeable(new Rectangle2D.Double(0,0,100, 100), null, null, null); 

    public static Resizeable initialSize(double width, double height) {
        return new Resizeable(new Rectangle2D.Double(0, 0, width, height), null, null, null);
    }

    Rectangle2D minSize, maxSize, initialSize;
    Double aspectRatio;

    public Resizeable() 
    {
        this(null, null, null, null);
    }

    public Resizeable(Rectangle2D initialSize, Rectangle2D minSize, Rectangle2D maxSize, Double fixedAspectRatio)
    {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.initialSize = initialSize;

        this.aspectRatio = fixedAspectRatio;
        if (aspectRatio!=null) {
            if (minSize!=null) {
                double msar = minSize.getWidth()/minSize.getHeight();
                if (Math.abs(msar-aspectRatio)>0.000001)
                    throw new RuntimeException("The aspect ratio of MinSize does not match the given fixed aspect ratio");
            }
            if (maxSize!=null) {
                double msar = maxSize.getWidth()/maxSize.getHeight();
                if (Math.abs(msar-aspectRatio)>0.000001)
                    throw new RuntimeException("The aspect ratio of MinSize does not match the given fixed aspect ratio");
            }
        }
    }

    @Override
    public Double getFixedAspectRatio(IElement e) {
        return aspectRatio;
    }

    @Override
    public Rectangle2D getMaximumSize(IElement e) {
        return maxSize;
    }

    @Override
    public Rectangle2D getMinimumSize(IElement e) {
        return minSize;
    }

    @Override
    public Rectangle2D getBounds(IElement e, Rectangle2D s) {
        if (s==null) s = new Rectangle2D.Double();
        s.setFrame((Rectangle2D)e.getHint(ElementHints.KEY_BOUNDS));
//		System.out.println(this+": returning bounds "+s);
        return s;
    }

    @Override
    public void resize(IElement e, Rectangle2D newSize) {
//		System.out.println(this+": bounds set to "+newSize);
        e.setHint(ElementHints.KEY_BOUNDS, newSize);
        /*
		double ar = maxSize.getWidthe()/maxSize.getHeight();
		if (Math.abs(ar-aspectRatio)>0.000001)
			throw new RuntimeException("The aspect ratio of MinSize does not match the given fixed aspect ratio");
         */
    }

    @Override
    public void validate(IElement e, ICanvasContext ctx, Collection<Issue> lst) {
        // TODO Validate aspect ratio
        if (aspectRatio!=null) {

        }
    }

    @Override
    public void onElementActivated(IDiagram d, IElement e) {
    }

    @Override
    public void onElementCreated(IElement e) {
        if (initialSize!=null)
            e.setHint(ElementHints.KEY_BOUNDS, initialSize);
        else
            e.setHint(ElementHints.KEY_BOUNDS, new Rectangle2D.Double(0,0,1,1));

    }

    @Override
    public void onElementDestroyed(IElement e) {
    }

    @Override
    public void onElementDeactivated(IDiagram d, IElement e) {
    }

}
