/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.impl.EnabledImpl;

/**
 * 
 * @See {@link EnabledImpl} implementation
 * @author Toni Kalajainen
 */
public interface Stateful extends ElementHandler {

	public static final EnabledImpl ENABLED_BY_DEFAULT = EnabledImpl.ENABLED_BY_DEFAULT;
	public static final EnabledImpl DISABLED_BY_DEFAULT = EnabledImpl.DISABLED_BY_DEFAULT;
	
	boolean	isEnabled(IElement e);
	void setEnabled(IElement e, boolean enabled);
	
}
