/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.diagram.handler;


/**
 * Defines the meaning of the relationship which must either remain internal
 * to a specific implementation or be published as API of an implementation
 * of this handler.
 * 
 * <p>
 * A relationship <em>can</em> also have an inverse relationship but doesn't
 * have to.
 * </p>
 * 
 * <p>
 * Implementations are strongly encouraged to have a <code>toString</code>
 * that states the name of the relationship.
 * </p>
 * 
 * @author Tuukka Lehtonen
 */
public interface Relationship {

    /**
     * @return null if there is no inverse relationship to this
     */
    Relationship getInverse();

    // Some standard relationships between elements

    /**
     * A compositional relationship between two elements. 
     */
    Relationship CHILD_OF = new Relationship() {
        public Relationship getInverse() { return PARENT_OF; }
        @Override
        public String toString() { return "CHILD OF"; }
    };
    Relationship PARENT_OF = new Relationship() {
        public Relationship getInverse() { return CHILD_OF; }
        @Override
        public String toString() { return "PARENT OF"; }
    };

    /**
     * A relationship between two elements without any further semantics.
     */
    Relationship RELATED_TO = new Relationship() {
        public Relationship getInverse() { return RELATED_TO; }
        @Override
        public String toString() { return "RELATED_TO"; }
    };

}