/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
#include "fastlz.h"
#include "lz4.h"
#include <stdio.h>
#include "jni.h"
#include <string.h>
#include <stdlib.h>

JNIEXPORT jint JNICALL Java_org_simantics_fastlz_FastLZ_compress(JNIEnv* env, jclass clazz, 
                                                                 jobject input, jint inputOffset, jint length, 
                                                                 jobject output, jint outputOffset) {
    void* inputAddress = (char*)(*env)->GetDirectBufferAddress(env, input) + inputOffset;
    void* outputAddress = (char*)(*env)->GetDirectBufferAddress(env, output) + outputOffset;
    return fastlz_compress(inputAddress, length, outputAddress);
}

JNIEXPORT jint JNICALL Java_org_simantics_fastlz_FastLZ_decompress(JNIEnv* env, jclass clazz, 
                                                                   jobject input, jint inputOffset, jint length, 
                                                                   jobject output, jint outputOffset, jint maxout) {
    void* inputAddress = (char*)(*env)->GetDirectBufferAddress(env, input) + inputOffset;
    void* outputAddress = (char*)(*env)->GetDirectBufferAddress(env, output) + outputOffset;
    return fastlz_decompress(inputAddress, length, outputAddress, maxout);
}

#define INITIAL_SIZE 2000000

JNIEXPORT jint JNICALL Java_org_simantics_fastlz_FastLZ_decompressCluster(JNIEnv* env, jclass clazz, jobject deflated, jint deflatedSize, jint inflatedSize, jobjectArray arrays) {

	static char *inflateBuffer = 0;
	static int inflateBufferSize = 0;

	int ll, il, bl;

	jlongArray longs;
	jintArray ints;
	jbyteArray bytes;

	char *input = (char*)(*env)->GetDirectBufferAddress(env, deflated);
	char *address;

	if(inflateBufferSize < inflatedSize) {
		if(!inflateBuffer) {
			if(inflatedSize < INITIAL_SIZE) inflatedSize = INITIAL_SIZE;
			inflateBuffer = malloc(inflatedSize);
			inflateBufferSize = inflatedSize;
		} else {
			if(inflateBuffer) free(inflateBuffer);
			inflateBuffer = malloc(inflatedSize);
			inflateBufferSize = inflatedSize;
		}
	}

	address = inflateBuffer;

	fastlz_decompress(input, deflatedSize, inflateBuffer, inflateBufferSize);

	ll = *(int *)address;
	longs = (*env)->NewLongArray(env, ll);
	(*env)->SetLongArrayRegion(env, longs, 0, ll, (const jlong *)(address + 4));
	(*env)->SetObjectArrayElement(env, arrays, 0, longs);

	address += 4 + 8 * ll;

	il = *(int *)address;
	ints = (*env)->NewIntArray(env, il);
	(*env)->SetIntArrayRegion(env, ints, 0, il, (const jint *)(address + 4));
	(*env)->SetObjectArrayElement(env, arrays, 1, ints);

	address += 4 * il + 4;

	bl = *(int *)address;
	bytes = (*env)->NewByteArray(env, bl);
	(*env)->SetByteArrayRegion(env, bytes, 0, bl, (const jbyte *)(address + 4));
	(*env)->SetObjectArrayElement(env, arrays, 2, bytes);

	return 0;

}

