/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.export.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.simantics.db.exception.DatabaseException;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.intf.ContentType;
import org.simantics.export.core.intf.Discoverer;
import org.simantics.export.core.intf.Exporter;
import org.simantics.export.core.intf.Format;
import org.simantics.export.core.intf.Publisher;
import org.simantics.export.core.manager.Content;
import org.simantics.export.core.manager.ExportWizardResult;
import org.simantics.export.core.util.ExportQueries;
import org.simantics.export.ui.Messages;
import org.simantics.export.ui.util.ExportUIQueries;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.datastructures.ToStringComparator;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.ui.workbench.StringMemento;

public class ContentSelectionPage
extends WizardPage {
    public static final String KEY_FORMAT_SELECTIONS = "org.simantics.modeling.ui.export.wizard.formatSelections";
    LocalResourceManager resourceManager;
    Grid grid;
    ExportContext ctx;
    String initialSelectionKey;
    Set<Content> initialSelection = new HashSet<Content>();
    StringMemento formatSelections;
    Collection<String> allModels;
    Collection<String> selectedModels;
    ToStringComparator toStringComparator = new ToStringComparator();
    MapList<ContentType, String> content;
    MapList<ContentType, Format> typeToFormatMap;
    MapList<String, ContentType> contentToTypeMap;
    Map<String, Map<String, String>> labels;
    MapList<String, String> modelContent;
    List<Content> contentSelection = new ArrayList<Content>();
    List<CTCheck> ctChecks = new ArrayList<CTCheck>();
    SelectionListener ctChecksListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (e.item == null || !(e.item instanceof GridItem)) {
                return;
            }
            int columnWidth = ContentSelectionPage.this.grid.getColumnCount();
            for (CTCheck cc : ContentSelectionPage.this.ctChecks) {
                boolean checked = cc.checkStatus();
                if (checked == cc.lastKnownCheckedStatus) continue;
                cc.lastKnownCheckedStatus = checked;
                GridItem[] gridItemArray = cc.gi.getItems();
                int n = gridItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GridItem gi = gridItemArray[n2];
                    int columnNumber = 0;
                    while (columnNumber < columnWidth) {
                        Object data = gi.getData(Integer.toString(columnNumber));
                        if (data != null && data instanceof Content) {
                            Content content = (Content)data;
                            if (content.formatId.equals(cc.format.id())) {
                                gi.setChecked(columnNumber, checked);
                            }
                        }
                        ++columnNumber;
                    }
                    ++n2;
                }
            }
        }
    };

    public ContentSelectionPage(ExportContext ctx) throws ExportException {
        super(Messages.ContentSelectionPage_SelectContent, Messages.ContentSelectionPage_SelectContentDescription, null);
        this.ctx = ctx;
        this.init();
    }

    void init() throws ExportException {
        try {
            int n;
            ContentType ct;
            System.out.println("Found Content Types:");
            Object object = this.ctx.eep.contentTypes();
            int n2 = ((ContentType[])object).length;
            int n3 = 0;
            while (n3 < n2) {
                ct = object[n3];
                System.out.println("   " + ct);
                ++n3;
            }
            System.out.println();
            System.out.println("Exporters:");
            object = this.ctx.eep.exporters();
            n2 = ((Exporter[])object).length;
            n3 = 0;
            while (n3 < n2) {
                ContentType ex = object[n3];
                System.out.println("   " + ex);
                ++n3;
            }
            System.out.println();
            System.out.println("Formats:");
            object = this.ctx.eep.formats();
            n2 = ((Format[])object).length;
            n3 = 0;
            while (n3 < n2) {
                ContentType format = object[n3];
                System.out.println("   " + format);
                ++n3;
            }
            System.out.println();
            System.out.println("Discoverers:");
            object = this.ctx.eep.discoverers();
            n2 = ((Discoverer[])object).length;
            n3 = 0;
            while (n3 < n2) {
                ContentType discoverer = object[n3];
                System.out.println("   " + discoverer);
                ++n3;
            }
            System.out.println();
            System.out.println("Publishers:");
            object = this.ctx.eep.publishers();
            n2 = ((Publisher[])object).length;
            n3 = 0;
            while (n3 < n2) {
                ContentType publisher = object[n3];
                System.out.println("   " + publisher.id());
                ++n3;
            }
            System.out.println();
            System.out.println("Mapped ContentTypes to Exporters:");
            this.typeToFormatMap = MapList.use(new TreeMap(this.toStringComparator));
            object = this.ctx.eep.contentTypes();
            n2 = ((ContentType[])object).length;
            n3 = 0;
            while (n3 < n2) {
                ct = object[n3];
                Exporter[] exporterArray = this.ctx.eep.getExportersForContentType(ct.id());
                n = exporterArray.length;
                int n4 = 0;
                while (n4 < n) {
                    Exporter exp = exporterArray[n4];
                    Format format = this.ctx.eep.getFormat(exp.formatId());
                    if (format != null) {
                        System.out.println("    " + ct.id() + " -> " + format.fileext());
                        if (!this.typeToFormatMap.contains((Object)ct, (Object)format)) {
                            this.typeToFormatMap.add((Object)ct, (Object)format);
                        }
                    }
                    ++n4;
                }
                ++n3;
            }
            System.out.println();
            this.allModels = (Collection)this.ctx.session.syncRequest(ExportUIQueries.models(this.ctx.project));
            int initialContentHash = 86981189;
            for (String content : this.ctx.selection) {
                initialContentHash = 13 * initialContentHash + content.hashCode();
            }
            this.initialSelectionKey = "InitialSelection-" + initialContentHash;
            String sel = this.ctx.store.get(this.initialSelectionKey, null);
            if (sel != null) {
                this.initialSelection = ExportWizardResult.parse((String)sel);
            } else {
                for (String contentUri : this.ctx.selection) {
                    this.initialSelection.add(new Content(contentUri, null, "all", null, null, null));
                }
            }
            this.selectedModels = new ArrayList<String>();
            StringBuilder modelsStr = new StringBuilder();
            for (String content : this.ctx.selection) {
                for (String model : this.allModels) {
                    if (!content.equals(model) && !content.startsWith(String.valueOf(model) + "/") || this.selectedModels.contains(model)) continue;
                    this.selectedModels.add(model);
                    if (modelsStr.length() > 0) {
                        modelsStr.append(", ");
                    }
                    modelsStr.append(model);
                }
            }
            if (this.selectedModels.isEmpty()) {
                this.selectedModels.addAll(this.ctx.activeModels);
            }
            if (this.selectedModels.isEmpty()) {
                this.selectedModels.addAll(this.allModels);
            }
            this.labels = new HashMap<String, Map<String, String>>();
            this.labels.put("model", (Map)this.ctx.session.syncRequest(ExportQueries.labels(this.selectedModels)));
            System.out.println("Discovering content: " + modelsStr);
            this.content = MapList.use(new TreeMap(this.toStringComparator));
            this.contentToTypeMap = MapList.use(new TreeMap(this.toStringComparator));
            this.modelContent = MapList.use(new TreeMap());
            for (ContentType ct2 : this.typeToFormatMap.getKeys()) {
                System.out.println("    " + ct2.label());
                Discoverer[] discovererArray = this.ctx.eep.getDiscoverers(ct2.id());
                int n5 = discovererArray.length;
                n = 0;
                while (n < n5) {
                    Discoverer discoverer = discovererArray[n];
                    System.out.println("         " + discoverer.toString());
                    Collection contents = discoverer.discoverContent(this.ctx, this.selectedModels);
                    ArrayList contentUris = new ArrayList(contents);
                    Map lbls = ct2.getLabels(this.ctx, contentUris);
                    this.labels.put(ct2.id(), lbls);
                    IndirectComparator comp = new IndirectComparator();
                    comp.labels = lbls;
                    Collections.sort(contentUris, comp);
                    for (String contentId : contentUris) {
                        this.content.add((Object)ct2, (Object)contentId);
                        this.contentToTypeMap.add((Object)contentId, (Object)ct2);
                        System.out.println("            " + contentId);
                    }
                    ++n;
                }
            }
            System.out.println();
        }
        catch (DatabaseException e) {
            throw new ExportException((Throwable)e);
        }
    }

    public void createControl(Composite parent) {
        this.grid = new Grid(parent, 2818);
        this.grid.setHeaderVisible(true);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.grid);
        Color contentTypeColor = this.resourceManager.createColor(new RGB(245, 245, 252));
        GridColumn column = new GridColumn(this.grid, 0);
        column.setTree(true);
        column.setText(Messages.ContentSelectionPage_Name);
        column.setWidth(200);
        this.assertColumnIndex(1);
        Format pdfFormat = this.ctx.eep.getFormat("pdf");
        ImageDescriptor folderID = null;
        try {
            URL folderUrl = new URL("platform:/plugin/com.famfamfam.silk/icons/folder.png");
            folderID = ImageDescriptor.createFromURL((URL)folderUrl);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        ArrayList<GridItem> selectedNodes = new ArrayList<GridItem>();
        for (String modelUri : this.contentToTypeMap.getKeys()) {
            ContentType modelContentType = null;
            for (ContentType ct : this.contentToTypeMap.getValues((Object)modelUri)) {
                if (!ct.isModel()) continue;
                modelContentType = ct;
                break;
            }
            if (modelContentType == null) continue;
            String modelLabel = this.labels.get("model").get(modelUri);
            GridItem modelNode = this.newLine(this.grid, modelLabel, modelUri, modelContentType.id());
            this.setIcon(modelNode, 0, modelContentType.icon(modelUri));
            modelNode.setToolTipText(0, modelUri);
            if (this.ctx.selection.contains(modelUri)) {
                selectedNodes.add(modelNode);
            }
            int column1 = 1;
            for (ContentType ct : this.contentToTypeMap.getValues((Object)modelUri)) {
                for (Format format : this.typeToFormatMap.getValues((Object)ct)) {
                    Image icon;
                    this.assertColumnIndex(++column1);
                    modelNode.setText(column1, format.fileext());
                    modelNode.setGrayed(column1, false);
                    modelNode.setCheckable(column1, true);
                    modelNode.setData(Integer.toString(column1), (Object)new Content(modelUri, ct.id(), format.id(), modelLabel, format.fileext(), modelUri));
                    modelNode.setChecked(column1, this.hasInitialSelection(modelUri, format.id()));
                    modelNode.setToolTipText(column1, format.label());
                    ImageDescriptor id = format.icon();
                    if (id == null || (icon = this.resourceManager.createImage(id)) == null) continue;
                    modelNode.setImage(column1, icon);
                }
            }
            for (ContentType ct : this.content.getKeys()) {
                if (ct.isModel()) continue;
                GridItem ctNode = this.newLine(modelNode, ct.label(), modelUri, ct.id());
                ctNode.setExpanded(true);
                ctNode.setBackground(0, contentTypeColor);
                ctNode.setBackground(contentTypeColor);
                this.setIcon(ctNode, 0, folderID);
                int contentCount = 0;
                ArrayList<Format> contentTypesFormats = new ArrayList<Format>();
                for (String contentUri : this.content.getValues((Object)ct)) {
                    if (!contentUri.startsWith(modelUri)) continue;
                    String nodeLabel = this.labels.get(ct.id()).get(contentUri);
                    GridItem contentNode = this.newLine(ctNode, nodeLabel, contentUri, ct.id());
                    ++contentCount;
                    contentNode.setToolTipText(0, contentUri);
                    this.setIcon(contentNode, 0, ct.icon(contentUri));
                    if (this.ctx.selection.contains(contentUri)) {
                        selectedNodes.add(contentNode);
                    }
                    int columnNumber = 0;
                    List formats = this.typeToFormatMap.getValues((Object)ct);
                    if (formats.contains(pdfFormat)) {
                        if (!contentTypesFormats.contains(pdfFormat)) {
                            contentTypesFormats.add(pdfFormat);
                        }
                        this.assertColumnIndex(++columnNumber);
                        contentNode.setText(columnNumber, "  " + pdfFormat.fileext());
                        contentNode.setGrayed(columnNumber, false);
                        contentNode.setCheckable(columnNumber, true);
                        contentNode.setChecked(columnNumber, this.hasInitialSelection(contentUri, pdfFormat.id()));
                        contentNode.setToolTipText(columnNumber, pdfFormat.label());
                        this.setIcon(contentNode, columnNumber, pdfFormat.icon());
                        contentNode.setData(Integer.toString(columnNumber), (Object)new Content(contentUri, ct.id(), pdfFormat.id(), nodeLabel, pdfFormat.fileext(), modelUri));
                    } else {
                        if (!contentTypesFormats.contains(null)) {
                            contentTypesFormats.add(null);
                        }
                        this.assertColumnIndex(++columnNumber);
                    }
                    for (Format format : formats) {
                        if (format == pdfFormat) continue;
                        if (!contentTypesFormats.contains(format)) {
                            contentTypesFormats.add(format);
                        }
                        this.assertColumnIndex(++columnNumber);
                        contentNode.setText(columnNumber, "  " + format.fileext());
                        contentNode.setGrayed(columnNumber, false);
                        contentNode.setCheckable(columnNumber, true);
                        contentNode.setChecked(columnNumber, this.hasInitialSelection(contentUri, format.id()));
                        contentNode.setToolTipText(columnNumber, format.label());
                        this.setIcon(contentNode, columnNumber, format.icon());
                        contentNode.setData(Integer.toString(columnNumber), (Object)new Content(contentUri, ct.id(), format.id(), nodeLabel, format.fileext(), modelUri));
                    }
                }
                int columnNumber = 0;
                HashSet<GridItem> gis = new HashSet<GridItem>();
                for (Format format : contentTypesFormats) {
                    ctNode.setBackground(++columnNumber, contentTypeColor);
                    if (format == null) continue;
                    this.ctChecks.add(new CTCheck(ctNode, columnNumber, format));
                    ctNode.setCheckable(columnNumber, true);
                    ctNode.setGrayed(columnNumber, true);
                    gis.add(ctNode);
                }
                if (contentCount != 0) continue;
                ctNode.dispose();
            }
            modelNode.setExpanded(true);
        }
        this.grid.setSelection(selectedNodes.toArray(new GridItem[selectedNodes.size()]));
        if (selectedNodes.size() > 0) {
            GridItem first = (GridItem)selectedNodes.get(0);
            this.grid.setFocusItem(first);
        }
        this.grid.addSelectionListener(this.ctChecksListener);
        this.setControl((Control)this.grid);
        this.setPageComplete(true);
    }

    void setIcon(GridItem node, int index, ImageDescriptor icon) {
        if (icon == null) {
            return;
        }
        Image image = this.resourceManager.createImage(icon);
        if (image == null) {
            return;
        }
        node.setImage(index, image);
    }

    void assertColumnIndex(int columnIndex) {
        while (columnIndex >= this.grid.getColumnCount()) {
            int cc = this.grid.getColumnCount();
            GridColumn column = new GridColumn(this.grid, 32);
            column.setText(cc == 1 ? Messages.ContentSelectionPage_Pages : Messages.ContentSelectionPage_Attachments);
            column.setWidth(cc == 1 ? 150 : 200);
            GridItem[] gridItemArray = this.grid.getItems();
            int n = gridItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                GridItem gi = gridItemArray[n2];
                gi.setGrayed(cc, true);
                gi.setCheckable(cc, false);
                ++n2;
            }
        }
    }

    boolean hasInitialSelection(String uri, String formatId) {
        for (Content c : this.initialSelection) {
            if (!c.url.equals(uri) || !c.formatId.equals("all") && !c.formatId.equals(formatId)) continue;
            return true;
        }
        return false;
    }

    GridItem newLine(Object parent, String label, String url, String contentTypeId) {
        GridItem gi = null;
        gi = parent instanceof Grid ? new GridItem((Grid)parent, 0) : new GridItem((GridItem)parent, 0);
        gi.setText(label);
        if (url != null || contentTypeId != null) {
            gi.setData((Object)new Content(url, contentTypeId, null, label, null, null));
        }
        int columnIndex = 0;
        while (columnIndex < this.grid.getColumnCount()) {
            gi.setGrayed(columnIndex, true);
            gi.setCheckable(columnIndex, false);
            ++columnIndex;
        }
        return gi;
    }

    public void validatePage() {
        ArrayList<Content> newContentSelection = new ArrayList<Content>();
        int columnWidth = this.grid.getColumnCount();
        HashSet checkedFormats = new HashSet();
        GridItem[] gridItemArray = this.grid.getItems();
        int n = gridItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            GridItem gi = gridItemArray[n2];
            int c = 0;
            while (c < columnWidth) {
                Object data = gi.getData(Integer.toString(c));
                if (data != null && data instanceof Content) {
                    Content content = (Content)data;
                    if (gi.getChecked(c) || checkedFormats.contains(content.formatId)) {
                        newContentSelection.add(content);
                    }
                }
                ++c;
            }
            ++n2;
        }
        this.contentSelection = newContentSelection;
    }

    public List<Content> getContentSelection() {
        return this.contentSelection;
    }

    public void savePrefs() {
        String str = ExportWizardResult.print(this.getContentSelection());
        this.ctx.store.put(this.initialSelectionKey, str);
    }

    static class CTCheck {
        GridItem gi;
        int columnNumber;
        Format format;
        boolean lastKnownCheckedStatus = false;
        boolean previousSelection;

        CTCheck(GridItem gi, int columnNumber, Format format) {
            this.gi = gi;
            this.columnNumber = columnNumber;
            this.format = format;
        }

        boolean checkStatus() {
            return this.gi.getChecked(this.columnNumber);
        }

        void setCheck(boolean checked) {
            this.gi.setChecked(this.columnNumber, checked);
        }
    }

    static class IndirectComparator
    implements Comparator<String> {
        Map<String, String> labels;

        IndirectComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            String l1 = null;
            String l2 = null;
            if (this.labels != null) {
                l1 = this.labels.get(o1);
                l2 = this.labels.get(o2);
            }
            if (l1 == null) {
                l1 = o1;
            }
            if (l2 == null) {
                l2 = o2;
            }
            return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)l1, (Object)l2);
        }
    }
}

