/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.export.core.pdf;

import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ImportPdfReader
implements Closeable {
    public File file;
    public PdfReader reader;
    List<Attachment> attachments;

    public ImportPdfReader() {
    }

    public ImportPdfReader(File file) throws IOException {
        this.file = file;
        this.reader = new PdfReader(file.getAbsolutePath());
    }

    public List<Attachment> getAttachments() {
        if (this.attachments != null) {
            return this.attachments;
        }
        this.attachments = new ArrayList<Attachment>();
        PdfDictionary root = this.reader.getCatalog();
        PdfDictionary names = (PdfDictionary)PdfReader.getPdfObject((PdfObject)root.get(PdfName.NAMES));
        if (names == null) {
            return this.attachments;
        }
        PdfDictionary embeddedfiles = names.getAsDict(PdfName.EMBEDDEDFILES);
        if (embeddedfiles == null) {
            return this.attachments;
        }
        PdfArray filespecs = embeddedfiles.getAsArray(PdfName.NAMES);
        if (filespecs == null) {
            return this.attachments;
        }
        int i = 0;
        while (i < filespecs.size()) {
            Attachment a = new Attachment();
            filespecs.getAsString(i++);
            a.filespec = filespecs.getAsDict(i++);
            a.refs = a.filespec.getAsDict(PdfName.EF);
            for (Object _key : a.refs.getKeys()) {
                a.key = (PdfName)_key;
                a.filename = a.filespec.getAsString(a.key);
                this.attachments.add(a);
            }
        }
        return this.attachments;
    }

    public List<Attachment> getAttachments(String extension) {
        ArrayList<Attachment> result = new ArrayList<Attachment>();
        for (Attachment a : this.getAttachments()) {
            if (!a.getFilename().endsWith(extension)) continue;
            result.add(a);
        }
        return result;
    }

    @Override
    public synchronized void close() {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    public static class Attachment {
        PdfDictionary filespec;
        PdfDictionary refs;
        PdfName key;
        PdfString filename;

        public String getFilename() {
            return this.filename.toUnicodeString();
        }

        public void saveTo(File file) throws IOException {
            if (!file.exists()) {
                file.createNewFile();
            }
            try (FileOutputStream fos = new FileOutputStream(file);){
                PRStream stream = (PRStream)PdfReader.getPdfObject((PdfObject)this.refs.getAsIndirectObject(this.key));
                fos.write(PdfReader.getStreamBytes((PRStream)stream));
                fos.flush();
            }
        }
    }
}

