package org.simantics.export.core.intf;

import java.util.Collection;

import org.simantics.db.request.Read;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;

/**
 * Discoverer extension
 *
 * @author toni.kalajainen@semantum.fi
 */
public interface Discoverer extends DiscoverAction {
	
	String contentTypeId();
	
	/**
	 * Discover content. 
	 * 
	 * @param ctx
	 * @param startLocations
	 * @return a collection of content uris.
	 * @throws ExportException
	 */
	Collection<String> discoverContent(ExportContext ctx, Collection<String> startLocations) throws ExportException;
	
}
