package org.simantics.export.core.intf;

import java.util.Collection;

import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;

/**
 * Interface for implementations that discover content in workspace and 
 * database. 
 *
 * @author toni.kalajainen@semantum.fi
 */
public interface DiscoverAction {
		
	/**
	 * Discover content. 
	 * 
	 * @param ctx
	 * @param startLocations
	 * @return a collection of content uris.
	 * @throws ExportException
	 */
	Collection<String> discoverContent(ExportContext ctx, Collection<String> startLocations) throws ExportException;
	
}
