/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.event.view.preference;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.event.ontology.EventViewResource;

/**
 * @author Tuukka Lehtonen
 */
public final class EventPrefs {

    public static boolean hideInfoEvents(ReadGraph graph, Resource project) throws DatabaseException {
        return testBoolean(graph, project, EventViewResource.getInstance(graph).HideInfoEvents);
    }

    public static boolean hideWarningEvents(ReadGraph graph, Resource project) throws DatabaseException {
        return testBoolean(graph, project, EventViewResource.getInstance(graph).HideWarningEvents);
    }

    public static boolean hideReturnEvents(ReadGraph graph, Resource project) throws DatabaseException {
        return testBoolean(graph, project, EventViewResource.getInstance(graph).HideReturnEvents);
    }

    public static boolean showHiddenEvents(ReadGraph graph, Resource project) throws DatabaseException {
        return testBoolean(graph, project, EventViewResource.getInstance(graph).ShowHiddenEvents);
    }

    public static boolean showOnlyMilestones(ReadGraph graph, Resource project) throws DatabaseException {
        return testBoolean(graph, project, EventViewResource.getInstance(graph).ShowOnlyMilestones);
    }

    public static boolean showOnlyActiveEvents(ReadGraph graph, Resource project) throws DatabaseException {
        return testBoolean(graph, project, EventViewResource.getInstance(graph).ShowOnlyActiveEvents);
    }

    private static boolean testBoolean(ReadGraph graph, Resource project, Resource property) throws DatabaseException {
        if (project == null)
            return false;
        return Boolean.TRUE.equals(graph.getPossibleRelatedValue(project, property, Bindings.BOOLEAN));
    }

    public static void setHideInfoEvents(WriteGraph graph, Resource project, boolean show) throws DatabaseException {
        setBoolean(graph, project, EventViewResource.getInstance(graph).HideInfoEvents, show);
    }

    public static void setHideWarningEvents(WriteGraph graph, Resource project, boolean show) throws DatabaseException {
        setBoolean(graph, project, EventViewResource.getInstance(graph).HideWarningEvents, show);
    }

    public static void setHideReturnEvents(WriteGraph graph, Resource project, boolean show) throws DatabaseException {
        setBoolean(graph, project, EventViewResource.getInstance(graph).HideReturnEvents, show);
    }

    public static void setShowHiddenEvents(WriteGraph graph, Resource project, boolean show) throws DatabaseException {
        setBoolean(graph, project, EventViewResource.getInstance(graph).ShowHiddenEvents, show);
    }

    public static void setShowOnlyMilestones(WriteGraph graph, Resource project, boolean show) throws DatabaseException {
        setBoolean(graph, project, EventViewResource.getInstance(graph).ShowOnlyMilestones, show);
    }

    public static void setShowOnlyActiveEvents(WriteGraph graph, Resource project, boolean show) throws DatabaseException {
        setBoolean(graph, project, EventViewResource.getInstance(graph).ShowOnlyActiveEvents, show);
    }

    private static void setBoolean(WriteGraph graph, Resource project, Resource property, boolean value) throws DatabaseException {
        graph.claimLiteral(project, property, value, Bindings.BOOLEAN);
    }

}
