/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.event.view.handler;

import java.util.Collection;

import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.event.ontology.EventResource;

/**
 * This action fixes all MilestoneLabels of an EventLog.
 * 
 * The label is derieved from the order number of an event. 
 * 
 * @author toni.kalajainen
 */
public class CorrectMilestoneLabelsAction extends WriteRequest {

	Resource eventlog;

	public CorrectMilestoneLabelsAction(Resource eventlog, VirtualGraph vg) {
		super(vg);
		this.eventlog = eventlog;
	}

	@Override
	public void perform(WriteGraph graph) throws DatabaseException {
		EventResource EVENT = EventResource.getInstance(graph);
		MilestoneList ml = graph.sync( new MilestoneListQuery( eventlog ) );
		//System.out.println("Setting labels");
		if ( !ml.milestones.isEmpty() ) {
			for (int i=0; i<ml.milestones.size(); i++) {
				String lbl = Integer.toString( i+1 );
				Resource milestone = ml.milestones.get(i);
				graph.claimLiteral(milestone, EVENT.Event_milestoneLabel, lbl, Bindings.STRING);
				//System.out.println("Setting "+milestone+" to "+lbl);
			}
		}

	}

	public static void correctMilestoneLabels(WriteGraph graph, VirtualGraph vg, Collection<Resource> events) throws DatabaseException {
		Collection<Resource> eventlogs = graph.sync( new GetEventLogsQuery( events ) );
		for (Resource eventlog : eventlogs) {
			graph.syncRequest( new CorrectMilestoneLabelsAction(eventlog, vg) );
		}
	}

}
