/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.event.view.contribution;

import java.awt.Color;
import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.model.images.ImageRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.event.Activator;
import org.simantics.event.ontology.EventResource;
import org.simantics.event.view.Constants;
import org.simantics.utils.datastructures.ArrayMap;
import org.simantics.utils.ui.BundleUtils;
import org.simantics.utils.ui.gfx.AlphaAdjustmentImageDescriptor;
import org.simantics.utils.ui.gfx.CompositionImageDescriptor;
import org.simantics.utils.ui.gfx.TextImageDescriptor;

/**
 * @author Tuukka Lehtonen
 */
public enum EventImageRule implements ImageRule {

    INSTANCE;

    public static EventImageRule get() {
        return INSTANCE;
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    @Override
    public Map<String, ImageDescriptor> getImage(ReadGraph graph, Object content) throws DatabaseException {
        Resource event = (Resource) content;

        EventResource EVENT = EventResource.getInstance(graph);

        ImageDescriptor eventIcon = null;
        ImageDescriptor milestoneIcon = null;
        ImageDescriptor returnIcon = null;

        // Icon derived from event type
        Resource eventType = graph.getPossibleObject(event, EVENT.Event_type);
        if (eventType != null) {
            eventIcon = graph.syncRequest(new EventTypeImageDescriptorRequest(eventType));
        }

        // Milestone Diamond Icon
        if (graph.hasStatement(event, EVENT.Milestone)) {
            String label = graph.getPossibleRelatedValue(event, EVENT.Event_milestoneLabel);
            if (label == null) label = "?";

            boolean isBasetime = graph.hasStatement(event, EVENT.EventLog_HasBaselineEvent_Inverse);
            ImageDescriptor diamond = isBasetime ? Activator.DIAMOND2_ICON : Activator.DIAMOND_ICON;
            int color = isBasetime ? 0 : Color.ORANGE.getRGB();
            ImageDescriptor number = new TextImageDescriptor(label, 16, 16, "Tahoma", 8, 0, color);
            milestoneIcon = CompositionImageDescriptor.compose( diamond, number );
        }

        if (!graph.hasStatement(event, EVENT.NoReturn)) {
            if (graph.hasStatement(event, EVENT.ReturnedBy)) {
                returnIcon = BundleUtils.getImageDescriptorFromPlugin("com.famfamfam.silk", "icons/tick.png");
            } else if (graph.hasStatement(event, EVENT.ReturnEvent)) {
                returnIcon = BundleUtils.getImageDescriptorFromPlugin("com.famfamfam.silk", "icons/arrow_undo.png");
            } else {
                returnIcon = BundleUtils.getImageDescriptorFromPlugin("com.famfamfam.silk", "icons/cross.png");
            }
        }

        boolean hidden = graph.hasStatement(event, EVENT.Hidden);

        eventIcon = fade(eventIcon, hidden);
        milestoneIcon = fade(milestoneIcon, hidden);
        returnIcon = fade(returnIcon, hidden);

        return ArrayMap.make(Constants.COLUMN_KEYS, new ImageDescriptor[] {
                null,
                null,
                null,
                milestoneIcon,
                eventIcon,
                returnIcon,
                null,
                null,
                null,
                null,
                null
        });
    }

    private static ImageDescriptor fade(ImageDescriptor desc, boolean doIt) {
        return desc != null && doIt ? AlphaAdjustmentImageDescriptor.adjustAlpha(desc, 128) : desc;
    }

}
