package org.simantics.event.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.event.ontology.EventResource;
import org.simantics.layer0.Layer0;
import org.simantics.utils.strings.AlphanumComparator;

public class EventWriteData {
	
	public VirtualGraph vg;
	public Layer0 L0;
	public Resource eventLog;
	public Resource targetSlice;
	public String sliceName;
	public int counter;
	public Resource counterResource;
	public Resource firstSliceResource;
	public Map<String,Resource> slices;
	
	public int targetPos;
	public int targetSliceNumber;
	
	public EventWriteData(ReadGraph graph, Resource eventLog, VirtualGraph vg) throws DatabaseException {
		EventResource EVENT = EventResource.getInstance(graph);
		this.vg = vg;
		this.L0 = Layer0.getInstance(graph);
		this.eventLog = eventLog;
		this.counterResource = graph.getSingleObject(eventLog, EVENT.HasModificationCounter);
		this.counter = graph.getValue(this.counterResource, Bindings.INTEGER);  
        int sliceNumber = this.counter / EventUtils.SLICE_SIZE;
        this.targetSlice = Layer0Utils.getPossibleChild(graph, eventLog, ""+sliceNumber);
        this.sliceName = (this.targetSlice != null) ? ""+sliceNumber : "";
        this.slices = graph.syncRequest(new UnescapedChildMapOfResource(eventLog));
	}
	
	public void prepareToWrite(WriteOnlyGraph graph) throws DatabaseException {

		targetPos = counter % EventUtils.SLICE_SIZE;
	    targetSliceNumber = counter / EventUtils.SLICE_SIZE;
	    
	    if(targetPos == 0 && !sliceName.equals(""+targetSliceNumber)) {
	    	Layer0 L0 = graph.getService(Layer0.class);
	    	EventResource EVENT = graph.getService(EventResource.class);
	    	targetSlice = graph.newResource();
	        graph.claim(targetSlice, L0.InstanceOf, null, EVENT.EventSlice);
	        graph.addLiteral(targetSlice, L0.HasName, L0.NameOf, L0.String, ""+targetSliceNumber, Bindings.STRING);
	        graph.claim(targetSlice, L0.PartOf, L0.ConsistsOf, eventLog);
	        slices.put(""+targetSliceNumber, targetSlice);
	        sliceName = ""+targetSliceNumber;
	    }
		
	}
	
	public void written() {
        counter++;
	}
	
	public void commit(WriteOnlyGraph graph) throws DatabaseException {
		
        graph.claimValue(counterResource, counter, Bindings.INTEGER);
        
        int toRemove = Math.max(slices.size() - EventUtils.KEEPS_SLICES, 0); 
        
        if(toRemove > 0) {
//        	System.err.println("toRemove with counter=" + counter);
        	ArrayList<String> keys = new ArrayList<String>(slices.keySet());
        	Collections.sort(keys, AlphanumComparator.COMPARATOR);
        	for(int i=0;i<toRemove;i++) {
//            	System.err.println("-remove " + keys.get(i));
        		graph.deny(eventLog, L0.ConsistsOf, L0.PartOf, slices.get(keys.get(i)), vg);
        	}
        }
        
        
        
	}
	
}