/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.event;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.simantics.utils.ui.gfx.AlphaAdjustmentImageDescriptor;
import org.simantics.utils.ui.gfx.HSVAdjustmentImageDescriptor;

/**
 * @author Tuukka Lehtonen
 */
public class Activator extends AbstractUIPlugin {

    public static final String   BUNDLE_ID = "org.simantics.event";

    private static BundleContext context;

    public static ImageDescriptor HIDE_ICON;
    public static ImageDescriptor UNHIDE_ICON;
    public static ImageDescriptor MILESTONE_ICON;
    public static ImageDescriptor DIAMOND_ICON, DIAMOND2_ICON;
    public static ImageDescriptor MARK_MILESTONE_ICON;
    public static ImageDescriptor UNMARK_MILESTONE_ICON;
    public static ImageDescriptor SET_BASELINE_ICON;
    public static ImageDescriptor REMOVE_BASELINE_ICON;
    public static ImageDescriptor CLIPBOARD_ICON;

    static BundleContext getContext() {
        return context;
    }

    @Override
    public void start(BundleContext bundleContext) throws Exception {
        Activator.context = bundleContext;

        Bundle bundle = bundleContext.getBundle();

        HIDE_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/hide.png"));
        UNHIDE_ICON = AlphaAdjustmentImageDescriptor.adjustAlpha(HSVAdjustmentImageDescriptor.adjust(ImageDescriptor.createFromURL(bundle.getResource("icons/hide.png")), 0f, 0f, 1f), 96);
        MILESTONE_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/milestone.png"));
        DIAMOND_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/diamond.png"));
        DIAMOND2_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/diamond2.png"));
        MARK_MILESTONE_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/milestone.png"));
        UNMARK_MILESTONE_ICON = AlphaAdjustmentImageDescriptor.adjustAlpha(HSVAdjustmentImageDescriptor.adjust(ImageDescriptor.createFromURL(bundle.getResource("icons/milestone.png")), 0f, 0f, 1f), 96);
        SET_BASELINE_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/baseline.png"));
        REMOVE_BASELINE_ICON = AlphaAdjustmentImageDescriptor.adjustAlpha(HSVAdjustmentImageDescriptor.adjust(ImageDescriptor.createFromURL(bundle.getResource("icons/baseline.png")), 0f, 0f, 1f), 96);
        CLIPBOARD_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/clipboard.png"));
    }

    @Override
    public void stop(BundleContext bundleContext) throws Exception {
        Activator.context = null;
    }

}
