/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.editors;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.simantics.editors.Activator;
import org.simantics.editors.BrowserInput;

public class Browser
extends EditorPart {
    public static final String ID = "org.simantics.editors.browser";
    org.eclipse.swt.browser.Browser browser;
    ToolBar toolbar;
    LocalResourceManager resourceManager;
    private final ImageDescriptor BACK_IMAGE = Activator.imageDescriptorFromPlugin((String)"org.simantics.editors", (String)"icons/browser/arrow_left.png");
    private final ImageDescriptor FORWARD_IMAGE = Activator.imageDescriptorFromPlugin((String)"org.simantics.editors", (String)"icons/browser/arrow_right.png");
    private final ImageDescriptor STOP_IMAGE = Activator.imageDescriptorFromPlugin((String)"org.simantics.editors", (String)"icons/browser/stop.png");
    private final ImageDescriptor REFRESH_IMAGE = Activator.imageDescriptorFromPlugin((String)"org.simantics.editors", (String)"icons/browser/arrow_rotate_clockwise.png");
    private Shell fsShell;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof BrowserInput)) {
            throw new PartInitException("Input must be instance of BrowserInput");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(this.getEditorInput().getName());
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        Image backImage = this.resourceManager.createImage(this.BACK_IMAGE);
        Image forwardImage = this.resourceManager.createImage(this.FORWARD_IMAGE);
        Image stopImage = this.resourceManager.createImage(this.STOP_IMAGE);
        Image refreshImage = this.resourceManager.createImage(this.REFRESH_IMAGE);
        BrowserInput input = (BrowserInput)this.getEditorInput();
        boolean fullscreen = input.isFullscreen();
        if (fullscreen) {
            this.fsShell = new Shell(parent.getDisplay());
            this.fsShell.setLayout((Layout)new GridLayout(1, false));
            this.fsShell.setLayout((Layout)new FillLayout());
            parent = new Composite((Composite)this.fsShell, 0);
            this.fsShell.open();
            this.fsShell.setFullScreen(true);
            parent.setLayout((Layout)new FillLayout());
        }
        String url = input.getUrl().toString();
        boolean showControls = input.isShowControls();
        if (showControls) {
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            composite.setLayout((Layout)gridLayout);
            this.toolbar = new ToolBar(composite, 0);
            ToolItem itemBack = new ToolItem(this.toolbar, 8);
            itemBack.setText("Back");
            itemBack.setImage(backImage);
            ToolItem itemForward = new ToolItem(this.toolbar, 8);
            itemForward.setText("Forward");
            itemForward.setImage(forwardImage);
            ToolItem itemStop = new ToolItem(this.toolbar, 8);
            itemStop.setText("Stop");
            itemStop.setImage(stopImage);
            ToolItem itemRefresh = new ToolItem(this.toolbar, 8);
            itemRefresh.setText("Refresh");
            itemRefresh.setImage(refreshImage);
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = false;
            data.horizontalAlignment = 4;
            data.verticalAlignment = 0x1000000;
            data.horizontalSpan = 3;
            this.toolbar.setLayoutData((Object)data);
            Label labelAddress = new Label(composite, 0);
            labelAddress.setText("Address");
            final Text location = new Text(composite, 2048);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.horizontalSpan = 2;
            data.grabExcessHorizontalSpace = true;
            location.setLayoutData((Object)data);
            this.browser = new org.eclipse.swt.browser.Browser(composite, input.getBrowserStyle());
            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            data.verticalAlignment = 4;
            data.horizontalSpan = 3;
            this.browser.setLayoutData((Object)data);
            final Label statusl = new Label(composite, 0);
            data = new GridData(768);
            data.horizontalSpan = 2;
            statusl.setLayoutData((Object)data);
            final ProgressBar progressBar = new ProgressBar(composite, 0);
            data = new GridData();
            data.horizontalAlignment = 3;
            progressBar.setLayoutData((Object)data);
            this.browser.addProgressListener(new ProgressListener(){

                public void changed(ProgressEvent event) {
                    if (event.total == 0) {
                        return;
                    }
                    int ratio = event.current * 100 / event.total;
                    progressBar.setSelection(ratio);
                }

                public void completed(ProgressEvent event) {
                    progressBar.setSelection(0);
                }
            });
            this.browser.addStatusTextListener(new StatusTextListener(){

                public void changed(StatusTextEvent event) {
                    statusl.setText(event.text);
                }
            });
            this.browser.addLocationListener(new LocationListener(){

                public void changed(LocationEvent event) {
                    if (event.top) {
                        location.setText(event.location);
                    }
                    Browser.this.scheduleSetPartName();
                }

                public void changing(LocationEvent event) {
                }
            });
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    ToolItem item = (ToolItem)event.widget;
                    String string = item.getText();
                    if (string.equals("Back")) {
                        Browser.this.browser.back();
                    } else if (string.equals("Forward")) {
                        Browser.this.browser.forward();
                    } else if (string.equals("Stop")) {
                        Browser.this.browser.stop();
                    } else if (string.equals("Refresh")) {
                        Browser.this.browser.refresh();
                    }
                }
            };
            itemBack.addListener(13, listener);
            itemForward.addListener(13, listener);
            itemStop.addListener(13, listener);
            itemRefresh.addListener(13, listener);
        } else {
            this.browser = new org.eclipse.swt.browser.Browser(parent, input.getBrowserStyle());
            this.browser.addLocationListener(new LocationListener(){

                public void changed(LocationEvent event) {
                    Browser.this.scheduleSetPartName();
                }

                public void changing(LocationEvent event) {
                }
            });
        }
        this.browser.setUrl(url);
        if (fullscreen) {
            this.fsShell.layout(true, true);
        }
    }

    protected void scheduleSetPartName() {
        this.browser.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (Browser.this.browser.isDisposed()) {
                    return;
                }
                String name = Browser.this.getEditorInput().getName();
                Browser.this.setPartName(name);
            }
        });
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public void dispose() {
        if (this.fsShell != null) {
            this.fsShell.dispose();
        }
        super.dispose();
    }

    public org.eclipse.swt.browser.Browser getBrowser() {
        return this.browser;
    }
}

