/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui.dialogs;

import java.io.File;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.Simantics;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.document.DocumentResource;
import org.simantics.document.ui.dialogs.AnnotationConfigurator;
import org.simantics.document.ui.dialogs.Messages;
import org.simantics.document.ui.dialogs.TextInputDialog;
import org.simantics.utils.ui.validators.FileNameValidator;

public class FileDetailDialog
extends TextInputDialog {
    private String fileName;
    private String name;
    Text fileText;
    Text nameText;
    IInputValidator fileValidator;
    IInputValidator nameValidator;
    Composite annotationComposite;
    AnnotationConfigurator annotationConfigurator;

    public FileDetailDialog(Shell parentShell, Resource lib) {
        super(parentShell);
        try {
            this.annotationConfigurator = new AnnotationConfigurator(DocumentResource.getInstance((RequestProcessor)Simantics.getSession()).FileDocument, lib);
        }
        catch (DatabaseException databaseException) {}
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getName() {
        return this.name;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().hint(500, 500).applyTo((Control)composite);
        Label label = new Label(composite, 0);
        label.setText(Messages.FileDetailDialog_File);
        this.fileText = new Text(composite, 2052);
        Button browseButton = new Button(composite, 8);
        browseButton.setText(Messages.FileDetailDialog_Browse);
        label = new Label(composite, 0);
        label.setText(Messages.FileDetailDialog_Name);
        this.nameText = new Text(composite, 2052);
        label = new Label(composite, 0);
        label = new Label(composite, 0);
        label.setText(Messages.FileDetailDialog_Annotations);
        this.annotationComposite = new Composite(composite, 0);
        this.annotationComposite.setLayout((Layout)new FillLayout());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.fileText);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.nameText);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.annotationComposite);
        this.fileValidator = new FileNameValidator();
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FileDetailDialog.this.validate(FileDetailDialog.this.fileText, FileDetailDialog.this.fileValidator)) {
                    FileDetailDialog.this.fileName = FileDetailDialog.this.fileText.getText();
                    FileDetailDialog.this.updateName();
                }
            }
        });
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FileDetailDialog.this.validate(FileDetailDialog.this.nameText, FileDetailDialog.this.nameValidator)) {
                    FileDetailDialog.this.name = FileDetailDialog.this.nameText.getText();
                }
            }
        });
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(e.display.getActiveShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.*"});
                String s = dialog.open();
                if (s != null) {
                    FileDetailDialog.this.name = null;
                    FileDetailDialog.this.fileText.setText(s);
                }
            }
        });
        this.annotationConfigurator.createComposite(this.annotationComposite);
        return composite;
    }

    private void updateName() {
        String proposal;
        String newName;
        if (this.fileName.length() > 0 && (newName = this.updateName(proposal = new File(this.fileName).getName(), this.name)) != null) {
            this.name = newName;
            this.nameText.setText(this.name);
        }
    }

    public void setNameValidator(IInputValidator nameValidator) {
        this.nameValidator = nameValidator;
    }

    public AnnotationConfigurator getAnnotationConfigurator() {
        return this.annotationConfigurator;
    }
}

