/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.document.DocumentResource;
import org.simantics.document.ui.CSSSourceViewerConfiguration;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.ui.workbench.ResourceEditorInput2;
import org.simantics.utils.logging.TimeLogger;

public class CSSModuleEditorDocumentProvider
extends AbstractDocumentProvider {
    protected Resource resource;
    protected String currentText;
    protected boolean errorHappened;
    protected AnnotationModel annotationModel = new AnnotationModel();
    private final CSSSourceViewerConfiguration sourceViewer;
    boolean annotationsInitialized = false;

    public CSSModuleEditorDocumentProvider(CSSSourceViewerConfiguration sourceViewer) {
        this.sourceViewer = sourceViewer;
    }

    protected IDocument createDocument(Object element) throws CoreException {
        ResourceEditorInput2 input = (ResourceEditorInput2)element;
        this.resource = input.getResource();
        try {
            return (IDocument)Simantics.getSession().syncRequest((Read)new UniqueRead<Document>(){

                public Document perform(ReadGraph graph) throws DatabaseException {
                    DocumentResource DOC = DocumentResource.getInstance((ReadGraph)graph);
                    CSSModuleEditorDocumentProvider.this.currentText = (String)graph.getPossibleRelatedValue(CSSModuleEditorDocumentProvider.this.resource, DOC.cssDocument, (Binding)Bindings.STRING);
                    CSSModuleEditorDocumentProvider.this.errorHappened = false;
                    return new Document(CSSModuleEditorDocumentProvider.this.currentText != null ? CSSModuleEditorDocumentProvider.this.currentText : "");
                }
            });
        }
        catch (DatabaseException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            this.errorHappened = true;
            return new Document(sw.toString());
        }
    }

    protected void updateAnnotations() {
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                if (!graph.hasStatement(CSSModuleEditorDocumentProvider.this.resource)) {
                    return;
                }
                CSSModuleEditorDocumentProvider.this.setAnnotations(Collections.emptyList());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAnnotations(List<CompilationError> errors) {
        Object object = this.annotationModel.getLockObject();
        synchronized (object) {
            this.annotationModel.removeAllAnnotations();
            for (CompilationError error : errors) {
                Annotation annotation = new Annotation("org.eclipse.ui.workbench.texteditor.error", true, error.description);
                int begin = Locations.beginOf((long)error.location);
                int end = Locations.endOf((long)error.location);
                Position position = new Position(begin, end - begin);
                this.annotationModel.addAnnotation(annotation, position);
            }
        }
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        if (!this.annotationsInitialized) {
            this.updateAnnotations();
            this.annotationsInitialized = true;
        }
        return this.annotationModel;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        TimeLogger.resetTimeAndLog((String)"SCLModuleEditorDocumentProvider.doSaveDocument");
        this.currentText = document.get();
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                graph.markUndoPoint();
                DocumentResource DOC = DocumentResource.getInstance((ReadGraph)graph);
                graph.claimLiteral(CSSModuleEditorDocumentProvider.this.resource, DOC.cssDocument, (Object)CSSModuleEditorDocumentProvider.this.currentText, (Binding)Bindings.STRING);
                Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Saved CSS " + graph.getRelatedValue2(CSSModuleEditorDocumentProvider.this.resource, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING)));
            }
        });
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

    public boolean isModifiable(Object element) {
        return !this.errorHappened;
    }

    public boolean isReadOnly(Object element) {
        return this.errorHappened;
    }
}

