package org.simantics.document.ui;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class DocumentUIResource {
    
    public final Resource Alternative;
    public final Resource BrowseContext;
    public final Resource Browser;
    public final Resource CSSEditorContribution;
    public final Resource Content;
    public final Resource DocumentNotOldTest;
    public final Resource DocumentOldTest;
    public final Resource DocumentTabContribution;
    public final Resource DocumentTabContributionType;
    public final Resource Editor;
    public final Resource Functions;
    public final Resource Functions_boldModifier;
    public final Resource Functions_bulletListModifier;
    public final Resource Functions_canCreateDocument;
    public final Resource Functions_editorLoaded;
    public final Resource Functions_fontModifier;
    public final Resource Functions_hasDocument;
    public final Resource Functions_header1Modifier;
    public final Resource Functions_header2Modifier;
    public final Resource Functions_header3Modifier;
    public final Resource Functions_header4Modifier;
    public final Resource Functions_horizontalRulerModifier;
    public final Resource Functions_imageModifier;
    public final Resource Functions_indentModifier;
    public final Resource Functions_internalLinkModifier;
    public final Resource Functions_isWikitext;
    public final Resource Functions_italicModifier;
    public final Resource Functions_linkModifier;
    public final Resource Functions_locationChanging;
    public final Resource Functions_noDocumentText;
    public final Resource Functions_numberedListModifier;
    public final Resource Functions_onCreateDocumentButton;
    public final Resource Functions_onDeleteDocumentButton;
    public final Resource Functions_selectedDocumentPart;
    public final Resource Functions_strikethroughModifier;
    public final Resource Functions_styleModifier;
    public final Resource Functions_tableModifier;
    public final Resource Functions_underlineModifier;
    public final Resource Functions_viewInputChanged;
    public final Resource Functions_wikitextModifier;
    public final Resource NoDocument;
    public final Resource Sash;
    public final Resource SearchContribution;
    public final Resource SearchFunction;
    public final Resource View;
    public final Resource WikitextContribution;
    public final Resource WikitextContribution_View;
    public final Resource WikitextContribution_View_Text;
    public final Resource WikitextContribution_View_TextContainer;
        
    public static class URIs {
        public static final String Alternative = "http://www.simantics.org/DocumentUI-1.1/Alternative";
        public static final String BrowseContext = "http://www.simantics.org/DocumentUI-1.1/BrowseContext";
        public static final String Browser = "http://www.simantics.org/DocumentUI-1.1/Browser";
        public static final String CSSEditorContribution = "http://www.simantics.org/DocumentUI-1.1/CSSEditorContribution";
        public static final String Content = "http://www.simantics.org/DocumentUI-1.1/Content";
        public static final String DocumentNotOldTest = "http://www.simantics.org/DocumentUI-1.1/DocumentNotOldTest";
        public static final String DocumentOldTest = "http://www.simantics.org/DocumentUI-1.1/DocumentOldTest";
        public static final String DocumentTabContribution = "http://www.simantics.org/DocumentUI-1.1/DocumentTabContribution";
        public static final String DocumentTabContributionType = "http://www.simantics.org/DocumentUI-1.1/DocumentTabContributionType";
        public static final String Editor = "http://www.simantics.org/DocumentUI-1.1/Editor";
        public static final String Functions = "http://www.simantics.org/DocumentUI-1.1/Functions";
        public static final String Functions_boldModifier = "http://www.simantics.org/DocumentUI-1.1/Functions/boldModifier";
        public static final String Functions_bulletListModifier = "http://www.simantics.org/DocumentUI-1.1/Functions/bulletListModifier";
        public static final String Functions_canCreateDocument = "http://www.simantics.org/DocumentUI-1.1/Functions/canCreateDocument";
        public static final String Functions_editorLoaded = "http://www.simantics.org/DocumentUI-1.1/Functions/editorLoaded";
        public static final String Functions_fontModifier = "http://www.simantics.org/DocumentUI-1.1/Functions/fontModifier";
        public static final String Functions_hasDocument = "http://www.simantics.org/DocumentUI-1.1/Functions/hasDocument";
        public static final String Functions_header1Modifier = "http://www.simantics.org/DocumentUI-1.1/Functions/header1Modifier";
        public static final String Functions_header2Modifier = "http://www.simantics.org/DocumentUI-1.1/Functions/header2Modifier";
        public static final String Functions_header3Modifier = "http://www.simantics.org/DocumentUI-1.1/Functions/header3Modifier";
        public static final String Functions_header4Modifier = "http://www.simantics.org/DocumentUI-1.1/Functions/header4Modifier";
        public static final String Functions_horizontalRulerModifier = "http://www.simantics.org/DocumentUI-1.1/Functions/horizontalRulerModifier";
        public static final String Functions_imageModifier = "http://www.simantics.org/DocumentUI-1.1/Functions/imageModifier";
        public static final String Functions_indentModifier = "http://www.simantics.org/DocumentUI-1.1/Functions/indentModifier";
        public static final String Functions_internalLinkModifier = "http://www.simantics.org/DocumentUI-1.1/Functions/internalLinkModifier";
        public static final String Functions_isWikitext = "http://www.simantics.org/DocumentUI-1.1/Functions/isWikitext";
        public static final String Functions_italicModifier = "http://www.simantics.org/DocumentUI-1.1/Functions/italicModifier";
        public static final String Functions_linkModifier = "http://www.simantics.org/DocumentUI-1.1/Functions/linkModifier";
        public static final String Functions_locationChanging = "http://www.simantics.org/DocumentUI-1.1/Functions/locationChanging";
        public static final String Functions_noDocumentText = "http://www.simantics.org/DocumentUI-1.1/Functions/noDocumentText";
        public static final String Functions_numberedListModifier = "http://www.simantics.org/DocumentUI-1.1/Functions/numberedListModifier";
        public static final String Functions_onCreateDocumentButton = "http://www.simantics.org/DocumentUI-1.1/Functions/onCreateDocumentButton";
        public static final String Functions_onDeleteDocumentButton = "http://www.simantics.org/DocumentUI-1.1/Functions/onDeleteDocumentButton";
        public static final String Functions_selectedDocumentPart = "http://www.simantics.org/DocumentUI-1.1/Functions/selectedDocumentPart";
        public static final String Functions_strikethroughModifier = "http://www.simantics.org/DocumentUI-1.1/Functions/strikethroughModifier";
        public static final String Functions_styleModifier = "http://www.simantics.org/DocumentUI-1.1/Functions/styleModifier";
        public static final String Functions_tableModifier = "http://www.simantics.org/DocumentUI-1.1/Functions/tableModifier";
        public static final String Functions_underlineModifier = "http://www.simantics.org/DocumentUI-1.1/Functions/underlineModifier";
        public static final String Functions_viewInputChanged = "http://www.simantics.org/DocumentUI-1.1/Functions/viewInputChanged";
        public static final String Functions_wikitextModifier = "http://www.simantics.org/DocumentUI-1.1/Functions/wikitextModifier";
        public static final String NoDocument = "http://www.simantics.org/DocumentUI-1.1/NoDocument";
        public static final String Sash = "http://www.simantics.org/DocumentUI-1.1/Sash";
        public static final String SearchContribution = "http://www.simantics.org/DocumentUI-1.1/SearchContribution";
        public static final String SearchFunction = "http://www.simantics.org/DocumentUI-1.1/SearchFunction";
        public static final String View = "http://www.simantics.org/DocumentUI-1.1/View";
        public static final String WikitextContribution = "http://www.simantics.org/DocumentUI-1.1/WikitextContribution";
        public static final String WikitextContribution_View = "http://www.simantics.org/DocumentUI-1.1/WikitextContribution/View";
        public static final String WikitextContribution_View_Text = "http://www.simantics.org/DocumentUI-1.1/WikitextContribution/View/Text";
        public static final String WikitextContribution_View_TextContainer = "http://www.simantics.org/DocumentUI-1.1/WikitextContribution/View/TextContainer";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public DocumentUIResource(ReadGraph graph) {
        Alternative = getResourceOrNull(graph, URIs.Alternative);
        BrowseContext = getResourceOrNull(graph, URIs.BrowseContext);
        Browser = getResourceOrNull(graph, URIs.Browser);
        CSSEditorContribution = getResourceOrNull(graph, URIs.CSSEditorContribution);
        Content = getResourceOrNull(graph, URIs.Content);
        DocumentNotOldTest = getResourceOrNull(graph, URIs.DocumentNotOldTest);
        DocumentOldTest = getResourceOrNull(graph, URIs.DocumentOldTest);
        DocumentTabContribution = getResourceOrNull(graph, URIs.DocumentTabContribution);
        DocumentTabContributionType = getResourceOrNull(graph, URIs.DocumentTabContributionType);
        Editor = getResourceOrNull(graph, URIs.Editor);
        Functions = getResourceOrNull(graph, URIs.Functions);
        Functions_boldModifier = getResourceOrNull(graph, URIs.Functions_boldModifier);
        Functions_bulletListModifier = getResourceOrNull(graph, URIs.Functions_bulletListModifier);
        Functions_canCreateDocument = getResourceOrNull(graph, URIs.Functions_canCreateDocument);
        Functions_editorLoaded = getResourceOrNull(graph, URIs.Functions_editorLoaded);
        Functions_fontModifier = getResourceOrNull(graph, URIs.Functions_fontModifier);
        Functions_hasDocument = getResourceOrNull(graph, URIs.Functions_hasDocument);
        Functions_header1Modifier = getResourceOrNull(graph, URIs.Functions_header1Modifier);
        Functions_header2Modifier = getResourceOrNull(graph, URIs.Functions_header2Modifier);
        Functions_header3Modifier = getResourceOrNull(graph, URIs.Functions_header3Modifier);
        Functions_header4Modifier = getResourceOrNull(graph, URIs.Functions_header4Modifier);
        Functions_horizontalRulerModifier = getResourceOrNull(graph, URIs.Functions_horizontalRulerModifier);
        Functions_imageModifier = getResourceOrNull(graph, URIs.Functions_imageModifier);
        Functions_indentModifier = getResourceOrNull(graph, URIs.Functions_indentModifier);
        Functions_internalLinkModifier = getResourceOrNull(graph, URIs.Functions_internalLinkModifier);
        Functions_isWikitext = getResourceOrNull(graph, URIs.Functions_isWikitext);
        Functions_italicModifier = getResourceOrNull(graph, URIs.Functions_italicModifier);
        Functions_linkModifier = getResourceOrNull(graph, URIs.Functions_linkModifier);
        Functions_locationChanging = getResourceOrNull(graph, URIs.Functions_locationChanging);
        Functions_noDocumentText = getResourceOrNull(graph, URIs.Functions_noDocumentText);
        Functions_numberedListModifier = getResourceOrNull(graph, URIs.Functions_numberedListModifier);
        Functions_onCreateDocumentButton = getResourceOrNull(graph, URIs.Functions_onCreateDocumentButton);
        Functions_onDeleteDocumentButton = getResourceOrNull(graph, URIs.Functions_onDeleteDocumentButton);
        Functions_selectedDocumentPart = getResourceOrNull(graph, URIs.Functions_selectedDocumentPart);
        Functions_strikethroughModifier = getResourceOrNull(graph, URIs.Functions_strikethroughModifier);
        Functions_styleModifier = getResourceOrNull(graph, URIs.Functions_styleModifier);
        Functions_tableModifier = getResourceOrNull(graph, URIs.Functions_tableModifier);
        Functions_underlineModifier = getResourceOrNull(graph, URIs.Functions_underlineModifier);
        Functions_viewInputChanged = getResourceOrNull(graph, URIs.Functions_viewInputChanged);
        Functions_wikitextModifier = getResourceOrNull(graph, URIs.Functions_wikitextModifier);
        NoDocument = getResourceOrNull(graph, URIs.NoDocument);
        Sash = getResourceOrNull(graph, URIs.Sash);
        SearchContribution = getResourceOrNull(graph, URIs.SearchContribution);
        SearchFunction = getResourceOrNull(graph, URIs.SearchFunction);
        View = getResourceOrNull(graph, URIs.View);
        WikitextContribution = getResourceOrNull(graph, URIs.WikitextContribution);
        WikitextContribution_View = getResourceOrNull(graph, URIs.WikitextContribution_View);
        WikitextContribution_View_Text = getResourceOrNull(graph, URIs.WikitextContribution_View_Text);
        WikitextContribution_View_TextContainer = getResourceOrNull(graph, URIs.WikitextContribution_View_TextContainer);
    }
    
    public static DocumentUIResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        DocumentUIResource ret = session.peekService(DocumentUIResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new DocumentUIResource(qc.getIndependentGraph(graph));
            session.registerService(DocumentUIResource.class, ret);
        }
        return ret;
    }
    
    public static DocumentUIResource getInstance(RequestProcessor session) throws DatabaseException {
        DocumentUIResource ret = session.peekService(DocumentUIResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<DocumentUIResource>() {
                public DocumentUIResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new DocumentUIResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(DocumentUIResource.class, ret);
        }
        return ret;
    }
    
}

