/*******************************************************************************
 * Copyright (c) 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.document.swt.core.widget;

import java.util.List;
import java.util.TreeMap;

import org.simantics.document.server.IEventCommand;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.bean.DataDefinition;
import org.simantics.document.server.client.WidgetData;
import org.simantics.document.server.client.WidgetManager;
import org.simantics.document.server.handler.AbstractEventHandler;
import org.simantics.document.server.io.CommandContext;
import org.simantics.document.server.io.CommandContextImpl;
import org.simantics.document.server.io.CommandContextMutable;
import org.simantics.document.server.io.ICommand;
import org.simantics.document.swt.core.SWTDocument;
import org.simantics.document.swt.core.base.PostEventCommand;
import org.simantics.document.swt.core.base.PropertyWidgetManager;

public class CommandEventWidget  extends PropertyWidgetManager<Object> {

    @Override
    public Object createWidget(JSONObject object) {
        return null;
    }

    @Override
    public void updateProperties(SWTDocument document, JSONObject object, Object widget) {
        // No properties
    }

    @Override
    public void updateChildren(SWTDocument document, JSONObject object, Object widget,
            TreeMap<String, WidgetData> childMap) {
        // No children
    }

    @Override
    public IEventCommand eventCommand(SWTDocument document, JSONObject object, Object component, ICommand command, CommandContext p) {
        if("event".equals(command.getCommand())) {
            List<DataDefinition> dataDefinitions = object.getJSONField("dataDefinitions");
            CommandContextMutable context = new CommandContextImpl();
            context.merge(p);
            context.merge(command.getConstants());
            for(DataDefinition dd : dataDefinitions) {
                WidgetData wd = document.getWidgetData().get(dd.getElementId());
                if(wd != null && wd.object != null) {
                    @SuppressWarnings("rawtypes")
                    WidgetManager manager = document.getManager(wd.object);
                    if(manager != null) {
                        @SuppressWarnings("unchecked")
                        String result = manager.getProperty(document, wd.object, wd.widget, dd.getProperty());
                        context.putValue(dd.getTarget(), result);
                    }
                }
            }
            AbstractEventHandler handler = object.getJSONField("SCLFunction");
            return new PostEventCommand(document, handler, context);
        } else {
            return null;
        }
    }
    
}
