package org.simantics.document.swt.core.selection;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.swt.ontology.SWTResources;
import org.simantics.selectionview.AbstractTypedVariableTabContribution;
import org.simantics.selectionview.ComparableTabContributor;

public class TypedVariableTabContribution extends AbstractTypedVariableTabContribution {

	public TypedVariableTabContribution(ReadGraph graph, Resource configuration) throws DatabaseException {
		super(graph, configuration);
	}

	@Override
	public void getContributors(ReadGraph graph, Variable variable, Integer priority, String label, Collection<ComparableTabContributor> result)
			throws DatabaseException {

		SWTResources SWTR = SWTResources.getInstance(graph);

		Resource view = graph.getPossibleObject(configuration, SWTR.TypedVariableTabContribution_HasView);
		if(view == null) {
			throw new DatabaseException("No view for " + graph.getPossibleURI(configuration));
		}

		final String viewURI = graph.getPossibleURI(view);
		
    	result.add(new ComparableTabContributor(new DocumentTabContributor(viewURI), priority, variable, label));
		
	}
	
}
