package org.simantics.document.swt.core.base;


import java.util.TreeMap;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.client.WidgetData;
import org.simantics.document.swt.core.SWTDocument;

public abstract class LeafWidgetManager<W extends Control> extends PropertyWidgetManager<WidgetContainer<W>> {

	class Container extends WidgetContainer<W> {
		
		@SuppressWarnings("unchecked")
		@Override
		protected void doUpdateProperties(SWTDocument document, Control control, JSONObject object) {
			LeafWidgetManager.this.doUpdateProperties(document, (W)control, object);
		}
		
		@Override
		protected Control doCreateControl(SWTDocument document, Composite parent, JSONObject object) {
			return LeafWidgetManager.this.doCreateControl(document, parent, object);
		}
		
	}
	
	@Override
	public WidgetContainer<W> createWidget(JSONObject object) {
		return new Container();
	}	
	
	@Override
	public void updateChildren(SWTDocument document, JSONObject object, WidgetContainer<W> widget, TreeMap<String,WidgetData> childMap) {
		throw new UnsupportedOperationException("Widget type " + object.getType() + " does not support children");
	}
	
	@Override
	public void updateProperties(SWTDocument document, JSONObject object, WidgetContainer<W> widget) {
		widget.updateProperties(document, object);
	}
	
	abstract protected void doUpdateProperties(SWTDocument document, W control, JSONObject object);
	abstract protected W doCreateControl(SWTDocument document, Composite parent, JSONObject object);
	
}