/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import org.simantics.db.common.procedure.adapter.ListenerAdapter;
import org.simantics.db.common.procedure.adapter.ListenerSupport;
import org.simantics.db.procedure.Listener;
import org.simantics.document.server.DocumentHistoryCollector;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.client.CommandManager;
import org.simantics.document.server.client.CommandMapping;
import org.simantics.document.server.client.Document;
import org.simantics.document.server.client.WidgetData;
import org.simantics.document.server.client.WidgetManager;
import org.simantics.document.server.client.WidgetMapping;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.threads.IThreadWorkQueue;

public abstract class DocumentClient
implements Document {
    protected HashMap<String, WidgetData> widgetData = new HashMap();
    private WidgetMapping mapping;
    private CommandMapping commandMapping;

    public DocumentClient(WidgetMapping mapping, CommandMapping commandMapping) {
        this.mapping = mapping;
        this.commandMapping = commandMapping;
    }

    @Override
    public WidgetManager<?, ?> getManager(JSONObject object) {
        return this.mapping.getWidget(object.getType());
    }

    @Override
    public WidgetData getWidget(String id) {
        return this.widgetData.get(id);
    }

    public abstract IThreadWorkQueue thread();

    protected void updateDocument(Collection<JSONObject> objects) {
        ArrayList<WidgetData> updatedData = new ArrayList<WidgetData>();
        for (JSONObject object : objects) {
            WidgetData datum = this.widgetData.get(object.getId());
            if (datum == null) {
                datum = new WidgetData(this, null, object);
                this.widgetData.put(object.getId(), datum);
            } else {
                datum.object = object;
            }
            updatedData.add(datum);
        }
        for (WidgetData datum : updatedData) {
            this.createElementIfNecessary(datum);
        }
        HashSet<WidgetData> updatedParents = new HashSet<WidgetData>();
        for (WidgetData datum : updatedData) {
            this.updateChildmaps(datum, updatedParents);
        }
        this.updateTree(updatedParents);
        for (WidgetData datum : updatedData) {
            datum.updateProperties();
            datum.updateCommands();
        }
    }

    private void createElementIfNecessary(WidgetData data) {
        if (data.widget == null) {
            data.widget = data.createElement();
        }
    }

    private void updateChildmaps(WidgetData data, HashSet<WidgetData> updates) {
        if (data.object == null) {
            return;
        }
        WidgetData parent = this.widgetData.get(data.object.getParent());
        if (parent == null) {
            return;
        }
        String parentOrd = data.object.getParentOrd();
        WidgetData existing = parent.childmap.get(parentOrd);
        if (!data.equals(existing)) {
            updates.add(parent);
            parent.childmap.put(parentOrd, data);
        }
    }

    protected void updateTree(HashSet<WidgetData> updates) {
        if (updates.isEmpty()) {
            return;
        }
        ArrayList<WidgetData> updateList = new ArrayList<WidgetData>(updates);
        Collections.sort(updateList, new Comparator<WidgetData>(){

            private boolean isParent(WidgetData data, WidgetData possibleParent) {
                WidgetData parent = DocumentClient.this.widgetData.get(data.object.getParent());
                if (parent == null) {
                    return false;
                }
                if (parent == possibleParent) {
                    return true;
                }
                return this.isParent(parent, possibleParent);
            }

            @Override
            public int compare(WidgetData arg0, WidgetData arg1) {
                if (arg0 == arg1) {
                    return 0;
                }
                if (this.isParent(arg0, arg1)) {
                    return 1;
                }
                if (this.isParent(arg1, arg0)) {
                    return -1;
                }
                return 0;
            }
        });
        for (WidgetData d : updateList) {
            d.updateChildren();
        }
    }

    public void track(ListenerSupport support, String document, String input) {
        new DocumentListener(support, document, input).perform();
    }

    WidgetData getRoot() {
        return this.widgetData.get("root");
    }

    <T> T getRootWidget() {
        return (T)this.getRoot().widget;
    }

    @Override
    public CommandManager<?, ?> getCommandManager(JSONObject object) {
        return this.commandMapping.getCommandManager(object.getType());
    }

    public class DocumentListener
    extends ListenerAdapter<Integer> {
        int revision = -1;
        private final ListenerSupport support;
        private final String document;
        private final String input;
        private boolean performing = false;
        Runnable updater = new Runnable(){

            @Override
            public void run() {
                DocumentListener.this.perform();
            }
        };

        public DocumentListener(ListenerSupport support, String document, String input) {
            this.support = support;
            this.document = document;
            this.input = input;
        }

        public synchronized void perform() {
            if (this.performing) {
                return;
            }
            this.performing = true;
            try {
                Pair<Integer, Collection<JSONObject>> content = DocumentHistoryCollector.getContent((Listener<Integer>)this, String.valueOf(this.document) + "/" + ">>>" + this.input + "/" + "<<<", this.revision);
                this.revision = (Integer)content.first;
                DocumentClient.this.updateDocument((Collection)content.second);
            }
            finally {
                this.performing = false;
            }
        }

        public void execute(Integer result) {
            IThreadWorkQueue thread = DocumentClient.this.thread();
            if (thread.currentThreadAccess()) {
                thread.syncExec(this.updater);
            } else {
                thread.asyncExec(this.updater);
            }
        }

        public boolean isDisposed() {
            return this.support.isDisposed();
        }
    }
}

