package org.simantics.document.server.request;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.AsyncReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableChildren;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.threads.logger.ITask;
import org.simantics.utils.threads.logger.ThreadLogger;

import gnu.trove.set.hash.THashSet;

public class NodesRequest extends VariableRead<Set<Variable>> {

    public NodesRequest(Variable var) {
        super(var);
    }

    @Override
    public Set<Variable> perform(ReadGraph graph) throws DatabaseException {

        ITask task = DocumentRequest.PROFILE ? ThreadLogger.task(this) : null;

        StructuralResource2.getInstance(graph);
        if(variable == null)
            return Collections.emptySet();

        Set<Variable> nodes = new THashSet<Variable>();

        Collection<Variable> children = graph.syncRequest(new VariableChildren(variable));

        graph.syncRequest(new AsyncReadRequest() {

            @Override
            public void run(AsyncReadGraph graph) throws DatabaseException {

                for(Variable child : children) {
                    graph.asyncRequest(new NodesRequest2(child), new AsyncProcedure<Set<Variable>>() {

                        @Override
                        public void execute(AsyncReadGraph graph, Set<Variable> result) {
                            synchronized(nodes) {
                                nodes.addAll(result);
                            }
                        }

                        @Override
                        public void exception(AsyncReadGraph graph, Throwable throwable) {
                        }
                        
                    });
                }

            }

        });

        if(DocumentRequest.PROFILE) task.finish();

        return nodes;

    }

}