package org.simantics.document.server;

import java.util.List;

import org.simantics.db.procedure.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentHistoryListener implements Listener<List<JSONObject>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentHistoryListener.class);

	final private DocumentHistory history;
    
    private boolean disposed = false;

    DocumentHistoryListener(DocumentHistory history) {
        this.history = history;
    }

    @Override
    public void execute(List<JSONObject> result) {
    	
    	synchronized(history) {

   			history.refresh(result);
    		if(!history.hasListeners()) {
    			history.removeUpdater();
    			disposed = true;
    		}
    		
    	}
        
    }

    @Override
    public void exception(Throwable t) {
        LOGGER.warn("DocumentHistoryListener received an exception.", t);
    }
    
    @Override
    public boolean isDisposed() {
    	if(!disposed) {
    		synchronized(history) {
    			if(!history.hasListeners()) {
    				history.removeUpdater();
    				disposed = true;
    			}
    		}
    	}
        return disposed;
    }

}
