/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization.graph.layer;

import java.util.Collection;
import java.util.Map;

import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.function.DbConsumer;
import org.simantics.g2d.layers.ILayer;
import org.simantics.g2d.layers.SimpleLayer;

/**
 * @author Tuukka Lehtonen
 */
public class GraphLayer {

    public static final String PROP_VISIBLE = "PROP_VISIBLE";
    public static final String PROP_FOCUSABLE = "PROP_FOCUSABLE";

    private final String   name;

    private final Resource layer;
    
    private final Map<String, Resource> tags;

    public GraphLayer(String name, Resource layer, Map<String, Resource> tags) {
        this.name = name;
        this.layer = layer;
        this.tags = tags;
    }

    public GraphLayer withName(String name) {
        return new GraphLayer(name, layer, tags);
    }

    public String getName() {
        return name;
    }

    public Resource getLayer() {
        return layer;
    }

    public Resource getVisible() {
        return tags.get(PROP_VISIBLE);
    }

    public Resource getFocusable() {
        return tags.get(PROP_FOCUSABLE);
    }

    public ILayer getILayer() {
        return new SimpleLayer(name);
    }

    public Collection<Resource> getTags() {
        return tags.values();
    }

    public void forEachTag(DbConsumer<Resource> consumer) throws DatabaseException {
        for (Resource r : tags.values())
            consumer.accept(r);
    }

}