/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization;

import org.simantics.db.WriteGraph;

/**
 * {@link ModificationAdapter} should be extended instead of directly
 * implementing this interface.
 * 
 * @author Tuukka Lehtonen
 * 
 * @see ModificationAdapter
 */
public interface IModification extends Comparable<IModification> {

    IModification[] NONE = {};

    void perform(WriteGraph g) throws Exception;

    void completed();

    boolean isComplete();

    Double getPriority();

    void markComplete();

    Throwable getException();

    void setException(Throwable t);

}