/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.query;

import gnu.trove.map.hash.THashMap;

import java.util.Collection;
import java.util.Map;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

/**
 * @author Tuukka Lehtonen
 */
public class AnnotationTypeProperties extends ResourceRead<Map<String, Resource>> {

    public AnnotationTypeProperties(Resource annotationType) {
        super(annotationType);
    }

    @Override
    public Map<String, Resource> perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        Collection<Resource> children = graph.getObjects(resource, L0.ConsistsOf);
        Map<String, Resource> properties = new THashMap<String, Resource>(children.size());
        for (Resource child : children) {
            if (graph.isSubrelationOf(child, L0.HasProperty)) {
                String name = graph.getPossibleRelatedValue2(child, L0.HasName, Bindings.STRING);
                if (name != null)
                    properties.put(name, child);
            }
        }
        return properties;
    }

}
