/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.participant;

import java.util.Collection;
import java.util.Collections;

/**
 * @author Tuukka Lehtonen
 */
public class ContextState {

    private Collection<String> contexts;
    private boolean            contextsSet;

    public ContextState() {
        this.contexts = Collections.emptyList();
        this.contextsSet = false;
    }

    public ContextState(String context) {
        this.contexts = Collections.singleton(context);
        this.contextsSet = true;
    }

    public ContextState(Collection<String> contexts) {
        setContexts(contexts);
    }

    void setContexts(Collection<String> contexts) {
        if (contextsSet)
            throw new IllegalStateException("contexts can only be set once");
        this.contexts = Collections.unmodifiableCollection(contexts);
        this.contextsSet = true;
    }

    Collection<String> getContexts() {
        return contexts;
    }

    boolean contextsAreSet() {
        return contextsSet;
    }
    
    @Override
    public String toString() {
        return "ContextState : " + getContexts().toString();
    }

}
