/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.content;

import java.util.Iterator;
import java.util.NoSuchElementException;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;

/**
 * @author Tuukka Lehtonen
 */
public final class EdgeResource /*extends OrderedPair<Resource>*/ implements Iterable<Resource>, Comparable<EdgeResource> {

    private final Resource first;
    private final Resource second;

    public EdgeResource(Resource first, Resource second) {
        this.first = first;
        this.second = second;
    }

    public String toString(ReadGraph g) throws DatabaseException {
        return "(" + NameUtils.getSafeName(g, first()) + ", " + NameUtils.getSafeName(g, second()) + ")";
    }

    public Resource first() {
        return first;
    }

    public Resource second() {
        return second;
    }

    @Override
    public int hashCode() {
        return first.hashCode() + second.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (!(obj instanceof EdgeResource))
            return false;
        EdgeResource other = (EdgeResource) obj;
        return (first.equals(other.first) && second.equals(other.second)) || (first.equals(other.second) && second.equals(other.first));
    }


    @Override
    public String toString() {
        //return "(" + first() + ", " + second() + ")";
        StringBuilder sb = new StringBuilder(32);
        sb.append('(');
        sb.append(first.getResourceId());
        sb.append(',');
        sb.append(second.getResourceId());
        sb.append(')');
        return sb.toString();
    }

    @Override
    public Iterator<Resource> iterator() {
        return new Iterator<Resource>() {
            int i = 0;

            @Override
            public boolean hasNext() {
                return i == 0;
            }

            @Override
            public Resource next() {
                ++i;
                switch (i) {
                    case 1: return first();
                    case 2: return second();
                    default:
                        throw new NoSuchElementException("element " + i + "is out of bounds, only two elements exist.");
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    final private long id() {
        return first.getResourceId() + second.getResourceId();
    }

    @Override
    public int compareTo(EdgeResource arg0) {
        long i = id();
        long i2 = arg0.id();
        if(i == i2) return 0;
        if(i < i2) return -1;
        else return 1;
    }

}