/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.adapter;

import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.exception.DatabaseException;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.utils.datastructures.hints.IHintObservable;

/**
 * This is a simple interface for loading diagrams from the graph.
 * 
 * @author Tuukka Lehtonen
 * @see GraphToDiagramSynchronizer
 */
public interface IDiagramLoader {

    /**
     * @param monitor for tracking loading progress
     * @param graph for reading the graph database
     * @param diagram the diagram resource
     * @param structuralPath the structural component path of the diagram to be
     *        loaded. If there's no structural path, {@link ResourceArray#NONE}
     *        can be used.
     * @param initialHintContext a set of initial hints that are to be set into
     *        the loaded diagram before the diagram contents are loaded or
     *        <code>null</code> there are no initial hints to be set
     * @return return the loaded diagram
     * @throws DatabaseException if something goes wrong while loading the
     *         diagram from the database
     */
    IDiagram loadDiagram(IProgressMonitor monitor, ReadGraph graph, String modelURI, Resource diagram, Resource runtime, ResourceArray structuralPath, IHintObservable initialHints) throws DatabaseException;

}
