/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.adapter;

import java.awt.Color;
import java.awt.Frame;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.tooltip.AWTTooltipProvider;

public class DefinedElementTooltipProvider extends AWTTooltipProvider {
	
	public static DefinedElementTooltipProvider INSTANCE = new DefinedElementTooltipProvider();
	
	@Override
	public void constructPopup(Frame frame, IElement element) {
		frame.setLayout(new BoxLayout(frame, BoxLayout.X_AXIS));
		JPanel panel = new JPanel();
		panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));
		Color c = new Color(255, 255, 220);
		panel.setBackground(c);
		panel.setBorder(BorderFactory.createLineBorder(Color.black));
		JLabel label = new JLabel(ElementUtils.getText(element));
		panel.add(label);
		frame.add(panel);
	}

}
