/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.adapter;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.elementclass.connection.EdgeClass;

/**
 * An element class factory for connection edge segments.
 * 
 * @author Tuukka Lehtonen
 */
public class DefaultConnectionEdgeClassFactory extends ElementFactoryAdapter {

    private static final ElementClass CLASS = EdgeClass.STRAIGHT;

    public static ElementClass create() {
        return CLASS;
    }

    @Override
    public void create(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementType,
            AsyncProcedure<ElementClass> procedure) {
        procedure.execute(graph, CLASS);
    }

    @Override
    public void getClass(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementResource,
            AsyncProcedure<ElementClass> procedure) {
        procedure.execute(graph, CLASS);
    }

}
