/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.desktop.ui.internal;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.Configuration;
import org.simantics.db.request.Read;
import org.simantics.db.request.WriteInterface;
import org.simantics.desktop.ui.internal.Messages;
import org.simantics.modeling.ModelingUtils;
import org.simantics.platform.ui.PlatformUIResource;
import org.simantics.spreadsheet.graph.SpreadsheetGraphUtils;
import org.simantics.spreadsheet.util.SpreadsheetUtils;

public class NewModel
extends AbstractHandler {
    public static Resource execute(WriteGraph graph) throws DatabaseException {
        PlatformUIResource PLATFORM = PlatformUIResource.getInstance((ReadGraph)graph);
        return NewModel.execute(graph, PLATFORM.Model, null);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        DatabaseJob job = new DatabaseJob(Messages.NewModel_NewModel){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Simantics.sync((WriteInterface)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            NewModel.execute(graph);
                        }
                    });
                    return Status.OK_STATUS;
                }
                catch (DatabaseException e) {
                    return new Status(4, "org.simantics.desktop.ui", NLS.bind((String)Messages.NewModel_0_Failed, (Object)this.getName()), (Throwable)e);
                }
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    public static Resource execute(WriteGraph graph, Resource type, String name) throws DatabaseException {
        Resource model = ModelingUtils.createModel((WriteGraph)graph, (Resource)type, (String)name);
        Resource conf = (Resource)graph.syncRequest((Read)new Configuration(model));
        ModelingUtils.addSCLMainToModel((WriteGraph)graph, (Resource)model, (String)"SCLMain", (String)"");
        ModelingUtils.createLocalLibrary((WriteGraph)graph, (Resource)model, (String)Messages.NewModel_Library);
        Resource book = SpreadsheetGraphUtils.createBook((WriteGraph)graph, (Resource)conf, (String)Messages.NewModel_Book1);
        SpreadsheetUtils.createSheet((WriteGraph)graph, (Resource)book, (String)Messages.NewModel_Sheet1, (String[])new String[0], (int[])new int[]{50});
        SpreadsheetUtils.createSheet((WriteGraph)graph, (Resource)book, (String)Messages.NewModel_Sheet2, (String[])new String[0], (int[])new int[]{50});
        SpreadsheetUtils.createSheet((WriteGraph)graph, (Resource)book, (String)Messages.NewModel_Sheet3, (String[])new String[0], (int[])new int[]{50});
        return model;
    }
}

