/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.request.Queries;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.utils.strings.EString;
import org.simantics.utils.threads.IThreadWorkQueue;

public class ResourceSearch
extends ReadRequest {
    public static final IResourceFilter FILTER_ALL = new IResourceFilter(){

        @Override
        public boolean acceptResource(ReadGraph g, Resource r) {
            return true;
        }
    };
    public static final IResourceFilter FILTER_RELATIONS = new IResourceFilter(){

        @Override
        public boolean acceptResource(ReadGraph g, Resource r) throws DatabaseException {
            return g.isInstanceOf(r, Layer0.getInstance((ReadGraph)g).Relation);
        }
    };
    public static final IResourceFilter FILTER_TYPES = new IResourceFilter(){

        @Override
        public boolean acceptResource(ReadGraph g, Resource r) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)g);
            return g.isInstanceOf(r, L0.Type) && !g.isInstanceOf(r, L0.Relation);
        }
    };
    boolean canceled = false;
    IResourceFilter filter;
    SearchListener listener;
    IThreadWorkQueue listenerThread;
    ResFoundQueue resFoundQueue;
    boolean asyncListening;

    public static final IResourceFilter createFilter(String txt) {
        final Pattern p = EString.compileSimplePattern((String)txt);
        return new IResourceFilter(){

            @Override
            public boolean acceptResource(ReadGraph g, Resource r) {
                String id;
                try {
                    String uri = (String)g.syncRequest(Queries.possibleUri((Resource)r));
                    if (uri != null && p.matcher(uri).matches()) {
                        return true;
                    }
                }
                catch (Throwable throwable) {}
                try {
                    String name = NameUtils.getSafeName((ReadGraph)g, (Resource)r);
                    if (p.matcher(name).matches()) {
                        return true;
                    }
                }
                catch (Throwable throwable) {}
                return p.matcher(id = Long.toString(r.getResourceId())).matches();
            }
        };
    }

    public ResourceSearch(IResourceFilter f, SearchListener l, IThreadWorkQueue listenerThread, boolean asyncListening) {
        assert (f != null && l != null);
        this.filter = f;
        this.listener = l;
        this.listenerThread = listenerThread;
        this.asyncListening = asyncListening;
        if (listenerThread != null) {
            this.resFoundQueue = new ResFoundQueue();
        }
    }

    public void cancel() {
        this.canceled = true;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void run(ReadGraph g) {
        try {
            if (!this.asyncListening && this.resFoundQueue != null) {
                this.resFoundQueue.g = g;
            }
            Resource root = g.getResource("http:/");
            Layer0 L0 = Layer0.getInstance((ReadGraph)g);
            LinkedList<Resource> queue = new LinkedList<Resource>();
            queue.add(root);
            HashSet<Resource> queued = new HashSet<Resource>();
            while (!queue.isEmpty() && !this.canceled) {
                Resource r = (Resource)queue.removeFirst();
                if (this.filter.acceptResource(g, r)) {
                    if (this.listenerThread == null) {
                        this.listener.onResourceFound((Read<?>)this, (Collection<Resource>)Collections.singletonList(r), g);
                    } else if (!this.resFoundQueue.addResource(r)) {
                        if (this.asyncListening) {
                            this.listenerThread.asyncExec((Runnable)this.resFoundQueue);
                        } else {
                            this.listenerThread.syncExec((Runnable)this.resFoundQueue);
                        }
                    }
                }
                for (Statement stm : g.getStatements(r, L0.IsWeaklyRelatedTo)) {
                    Resource n = stm.getPredicate();
                    if (!queued.contains(n)) {
                        queue.add(n);
                        queued.add(n);
                    }
                    if (queued.contains(n = stm.getObject())) continue;
                    queue.add(n);
                    queued.add(n);
                }
                if (this.listenerThread == null) {
                    this.listener.onSearchComplete((Read<?>)this);
                    continue;
                }
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        ResourceSearch.this.listener.onSearchComplete((Read<?>)ResourceSearch.this);
                    }
                };
                if (this.asyncListening) {
                    this.listenerThread.asyncExec(run);
                    continue;
                }
                this.listenerThread.syncExec(run);
            }
        }
        catch (Throwable e) {
            if (this.listenerThread == null) {
                this.listener.onError((Read<?>)this, e);
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    ResourceSearch.this.listener.onError((Read<?>)ResourceSearch.this, e);
                }
            };
            if (this.asyncListening) {
                this.listenerThread.asyncExec(r);
            }
            this.listenerThread.syncExec(r);
        }
    }

    public static interface IResourceFilter {
        public boolean acceptResource(ReadGraph var1, Resource var2) throws DatabaseException;
    }

    private class ResFoundQueue
    implements Runnable {
        ReadGraph g;
        List<Resource> list = new ArrayList<Resource>();

        private ResFoundQueue() {
        }

        synchronized boolean addResource(Resource r) {
            this.list.add(r);
            return this.list.size() > 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ArrayList<Resource> l = null;
                ResFoundQueue resFoundQueue = this;
                synchronized (resFoundQueue) {
                    if (this.list.size() == 0) {
                        return;
                    }
                    if (this.list.size() < 10) {
                        ResourceSearch.this.listener.onResourceFound((Read<?>)ResourceSearch.this, (Collection<Resource>)this.list, this.g);
                        this.list.clear();
                        return;
                    }
                    l = new ArrayList<Resource>(this.list);
                    this.list.clear();
                }
                ResourceSearch.this.listener.onResourceFound((Read<?>)ResourceSearch.this, (Collection<Resource>)l, this.g);
            }
            catch (DatabaseException databaseException) {}
        }
    }

    public static interface SearchListener {
        public void onResourceFound(Read<?> var1, Collection<Resource> var2, ReadGraph var3) throws DatabaseException;

        public void onSearchComplete(Read<?> var1);

        public void onError(Read<?> var1, Throwable var2);
    }
}

