/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.graphical.layout;

public class ExtensionLayoutAlgorithm {
    final double OPTIMAL_DISTANCE = 150.0;
    final double C = 0.1;
    final double K = 6.666666666666668E-4;
    final double G = 6.666666666666668E-4;
    final double Q = 2250.0;
    final double TOLERANCE = 0.001;
    final int MAX_ITERATIONS = 10000;
    final long TIMEOUT = 1000000000L;
    final double MAX_MOVE2 = 40000.0;
    int size;
    double[] posX;
    double[] posY;
    double[] forceX;
    double[] forceY;
    int repulsiveSize;
    double[] fixedRepulsiveX;
    double[] fixedRepulsiveY;
    double[][] neighbors;

    public ExtensionLayoutAlgorithm(double[][] neighbors, double[] fixedRepulsiveX, double[] fixedRepulsiveY) {
        this.size = neighbors.length;
        this.neighbors = neighbors;
        this.repulsiveSize = fixedRepulsiveX.length;
        this.fixedRepulsiveX = fixedRepulsiveX;
        this.fixedRepulsiveY = fixedRepulsiveY;
        this.posX = new double[this.size];
        this.posY = new double[this.size];
        this.forceX = new double[this.size];
        this.forceY = new double[this.size];
    }

    public double[] getPosX() {
        return this.posX;
    }

    public double[] getPosY() {
        return this.posY;
    }

    private void computeForces() {
        int i = 0;
        while (i < this.size) {
            double l2;
            double dy;
            double dx;
            double x = this.posX[i];
            double y = this.posY[i];
            double fx = -6.666666666666668E-4 * x;
            double fy = -6.666666666666668E-4 * y;
            int j = 0;
            while (j < this.size) {
                if (j != i) {
                    dx = this.posX[j] - x;
                    dy = this.posY[j] - y;
                    l2 = dx * dx + dy * dy;
                    fx -= 2250.0 * dx / l2;
                    fy -= 2250.0 * dy / l2;
                }
                ++j;
            }
            j = 0;
            while (j < this.repulsiveSize) {
                if (j != i) {
                    dx = this.fixedRepulsiveX[j] - x;
                    dy = this.fixedRepulsiveY[j] - y;
                    l2 = dx * dx + dy * dy;
                    fx -= 2250.0 * dx / l2;
                    fy -= 2250.0 * dy / l2;
                }
                ++j;
            }
            double[] ns = this.neighbors[i];
            int j2 = 0;
            while (j2 < ns.length) {
                double dx2 = ns[j2] - x;
                double dy2 = ns[j2 + 1] - y;
                double l22 = dx2 * dx2 + dy2 * dy2;
                double l = Math.sqrt(l22);
                fx += 6.666666666666668E-4 * l * dx2;
                fy += 6.666666666666668E-4 * l * dy2;
                j2 += 2;
            }
            this.forceX[i] = fx;
            this.forceY[i] = fy;
            ++i;
        }
    }

    private boolean converged() {
        int i = 0;
        while (i < this.size) {
            double fx = this.forceX[i];
            double fy = this.forceY[i];
            double f2 = fx * fx + fy * fy;
            if (f2 > 0.001) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void moveAll() {
        int i = 0;
        while (i < this.size) {
            double fx = this.forceX[i];
            double fy = this.forceY[i];
            double f2 = fx * fx + fy * fy;
            if (f2 > 40000.0) {
                double s = Math.sqrt(40000.0 / f2);
                fx *= s;
                fy *= s;
            }
            int n = i;
            this.posX[n] = this.posX[n] + fx;
            int n2 = i++;
            this.posY[n2] = this.posY[n2] + fy;
        }
        this.computeForces();
    }

    public void optimize() {
        this.computeForces();
        long beginTime = System.nanoTime();
        int iter = 0;
        while (iter < 10000) {
            if (this.converged() || (iter & 0xF) == 0 && System.nanoTime() - beginTime > 1000000000L) break;
            this.moveAll();
            ++iter;
        }
        System.out.println("Elapsed: " + (double)(System.nanoTime() - beginTime) * 1.0E-6 + " ms");
        System.out.println("Iterations: " + iter);
    }
}

