/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.graphical;

import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.JFrame;
import org.simantics.debug.graphical.DebuggerCanvas;
import org.simantics.debug.graphical.UsefulKeyAdapter;

public class GraphicalDebugger {
    public static DebuggerCanvas newGraphDebugger() {
        final JFrame frame = new JFrame();
        frame.setTitle("Graph debugger");
        Toolkit tk = Toolkit.getDefaultToolkit();
        frame.setIconImages(Arrays.asList(tk.createImage(GraphicalDebugger.class.getResource("bug-icon1.png")), tk.createImage(GraphicalDebugger.class.getResource("bug-icon2.png")), tk.createImage(GraphicalDebugger.class.getResource("bug-icon3.png")), tk.createImage(GraphicalDebugger.class.getResource("bug-icon4.png"))));
        frame.setSize(800, 600);
        final DebuggerCanvas canvas = new DebuggerCanvas();
        frame.add(canvas);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                canvas.repaint();
            }
        });
        frame.addKeyListener(new UsefulKeyAdapter(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                canvas.keyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                canvas.keyReleased(e);
            }
        }));
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                frame.dispose();
            }
        });
        frame.setVisible(true);
        return canvas;
    }
}

