package org.simantics.debug.graphical.model;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class LabelContent extends Content {
    public static final Font FONT = new Font("Arial", Font.PLAIN, 12);
    public static final FontRenderContext FRC = 
            new FontRenderContext(new AffineTransform(), true, true);
    public static final Rectangle2D MAX_BOUNDS = FONT.getMaxCharBounds(FRC);
    public static final double FONT_HEIGHT = MAX_BOUNDS.getHeight();
    public static double PADDING = 3.0;
    
    String[] labels;
    double textX, textY;
    
    public LabelContent(String[] labels) {
        setLabels(labels);
    }

    @Override
    public void render(Graphics2D g) {
        g.setFont(FONT);
        for(int i=0;i<labels.length;++i) {
            g.drawString(labels[i], (float)textX, (float)(textY + i*FONT_HEIGHT));    
        }        
    }
    
    public void setLabels(String[] labels) {
        this.labels = labels;

        double maxWidth = 0.0;
        for(String label : labels) {
            Rectangle2D bounds = FONT.getStringBounds(label, FRC);
            maxWidth = Math.max(maxWidth, bounds.getWidth());
        }
        
        textX = -0.5*maxWidth;
        textY = -0.5*labels.length*FONT_HEIGHT + FONT_HEIGHT - MAX_BOUNDS.getMaxY();
        
        radiusX = PADDING + 0.5*maxWidth;
        radiusY = PADDING + 0.5*labels.length*FONT_HEIGHT;
    }
    
}
