/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.browser.utils;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.debug.browser.utils.ValueInfo;
import org.simantics.layer0.Layer0;

public class Values {
    private static int RESOURCE_NAME_MAX_LENGTH = 1000;
    private static int RESOURCE_VALUE_MAX_SIZE = 16384;

    public static ValueInfo getPossibleValueInfo(ReadGraph graph, Resource r) {
        block18: {
            if (graph.hasValue(r)) break block18;
            return null;
        }
        try {
            String value = null;
            String datatype = null;
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Datatype type = (Datatype)graph.getPossibleRelatedValue(r, L0.HasDataType, Bindings.getBindingUnchecked(Datatype.class));
            if (type != null) {
                if (graph.isInstanceOf(r, L0.RVI)) {
                    try {
                        Variable context;
                        RVI rvi = (RVI)graph.getPossibleValue(r, ((Databoard)graph.getService(Databoard.class)).getBindingUnchecked(RVI.class));
                        Resource owner = CommonDBUtils.getPossibleOwner((ReadGraph)graph, (Resource)r);
                        if (owner != null && (context = Variables.getPossibleConfigurationContext((ReadGraph)graph, (Resource)owner)) != null) {
                            value = rvi.asPossibleString(graph, context);
                        }
                        if (value == null) {
                            value = rvi.toString(graph);
                        }
                        if (value != null) {
                            datatype = "Relative Variable Identifier (RVI)";
                        }
                    }
                    catch (DatabaseException databaseException) {}
                }
                if (value == null) {
                    Binding b = Bindings.getBinding((Datatype)type);
                    Object v = graph.getPossibleValue(r, b);
                    Serializer s = Bindings.getSerializerUnchecked((Binding)b);
                    int size = s.getSize(v);
                    if (size > RESOURCE_VALUE_MAX_SIZE) {
                        value = "Approx. " + size + " byte literal";
                    } else {
                        if (b instanceof ArrayBinding) {
                            int arraySize = ((ArrayBinding)b).size(v);
                            ArrayType atype = (ArrayType)type;
                            atype.setLength(Integer.toString(arraySize));
                        }
                        value = b.toString(v, false);
                    }
                    datatype = Bindings.getBindingUnchecked(Datatype.class).toString((Object)type, false);
                }
            }
            ValueInfo info = null;
            if (value != null) {
                info = new ValueInfo(r, value, datatype);
            }
            if (info == null) {
                info = Values.toSimpleValueInfo(r, graph.getValue(r));
            }
            return info;
        }
        catch (DatabaseException databaseException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (BindingException bindingException) {
            return null;
        }
    }

    private static ValueInfo toSimpleValueInfo(Resource r, Object value) {
        Class<?> clazz = value.getClass();
        if (clazz.isArray()) {
            int length = Array.getLength(value);
            if (length > RESOURCE_NAME_MAX_LENGTH) {
                if (value instanceof byte[]) {
                    byte[] arr = (byte[])value;
                    byte[] arr2 = Arrays.copyOf(arr, RESOURCE_NAME_MAX_LENGTH);
                    return Values.truncated(r, "byte", Arrays.toString(arr2), arr.length);
                }
                if (value instanceof int[]) {
                    int[] arr = (int[])value;
                    int[] arr2 = Arrays.copyOf(arr, RESOURCE_NAME_MAX_LENGTH);
                    return Values.truncated(r, "int", Arrays.toString(arr2), arr.length);
                }
                if (value instanceof long[]) {
                    long[] arr = (long[])value;
                    long[] arr2 = Arrays.copyOf(arr, RESOURCE_NAME_MAX_LENGTH);
                    return Values.truncated(r, "long", Arrays.toString(arr2), arr.length);
                }
                if (value instanceof float[]) {
                    float[] arr = (float[])value;
                    float[] arr2 = Arrays.copyOf(arr, RESOURCE_NAME_MAX_LENGTH);
                    return Values.truncated(r, "float", Arrays.toString(arr2), arr.length);
                }
                if (value instanceof double[]) {
                    double[] arr = (double[])value;
                    double[] arr2 = Arrays.copyOf(arr, RESOURCE_NAME_MAX_LENGTH);
                    return Values.truncated(r, "double", Arrays.toString(arr2), arr.length);
                }
                if (value instanceof boolean[]) {
                    boolean[] arr = (boolean[])value;
                    boolean[] arr2 = Arrays.copyOf(arr, RESOURCE_NAME_MAX_LENGTH);
                    return Values.truncated(r, "boolean", Arrays.toString(arr2), arr.length);
                }
                if (value instanceof Object[]) {
                    Object[] arr = (Object[])value;
                    Object[] arr2 = Arrays.copyOf(arr, RESOURCE_NAME_MAX_LENGTH);
                    return Values.truncated(r, "Object", Arrays.toString(arr2), arr.length);
                }
                return new ValueInfo(r, "", "Unknown big array " + clazz.getCanonicalName());
            }
            return new ValueInfo(r, ObjectUtils.toString((Object)value), clazz.getComponentType() + "[" + length + "]");
        }
        return new ValueInfo(r, ObjectUtils.toString((Object)value), clazz.getCanonicalName());
    }

    private static ValueInfo truncated(Resource r, String type, String value, int originalLength) {
        return new ValueInfo(r, value, String.valueOf(type) + "[" + RESOURCE_NAME_MAX_LENGTH + "/" + originalLength + "]");
    }
}

